/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Scheduler;
import kafka.utils.Scheduler$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001\u001d\u0011abS1gW\u0006\u001c6\r[3ek2,'O\u0003\u0002\u0004\t\u0005)Q\u000f^5mg*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u000b\u0001A\u0001\u0003F\f\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001\u00027b]\u001eT\u0011!D\u0001\u0005U\u00064\u0018-\u0003\u0002\u0010\u0015\t1qJ\u00196fGR\u0004\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\bCA\t\u0016\u0013\t1\"AA\u0004M_\u001e<\u0017N\\4\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t=\u0001\u0011)\u0019!C\u0001?\u00059A\u000f\u001b:fC\u0012\u001cX#\u0001\u0011\u0011\u0005a\t\u0013B\u0001\u0012\u001a\u0005\rIe\u000e\u001e\u0005\tI\u0001\u0011\t\u0011)A\u0005A\u0005AA\u000f\u001b:fC\u0012\u001c\b\u0005\u0003\u0005'\u0001\t\u0015\r\u0011\"\u0001(\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u00070F\u0001)!\tICF\u0004\u0002\u0019U%\u00111&G\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,3!A\u0001\u0007\u0001B\u0001B\u0003%\u0001&A\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jq\u0002B\u0001B\r\u0001\u0003\u0002\u0003\u0006IaM\u0001\u0007I\u0006,Wn\u001c8\u0011\u0005a!\u0014BA\u001b\u001a\u0005\u001d\u0011un\u001c7fC:DQa\u000e\u0001\u0005\u0002a\na\u0001P5oSRtD\u0003B\u001d;wq\u0002\"!\u0005\u0001\t\u000by1\u0004\u0019\u0001\u0011\t\u000f\u00192\u0004\u0013!a\u0001Q!9!G\u000eI\u0001\u0002\u0004\u0019\u0004b\u0002 \u0001\u0001\u0004%IaP\u0001\tKb,7-\u001e;peV\t\u0001\t\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0015c\u0011\u0001B;uS2L!a\u0012\"\u00037M\u001b\u0007.\u001a3vY\u0016$G\u000b\u001b:fC\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s\u0011\u001dI\u0005\u00011A\u0005\n)\u000bA\"\u001a=fGV$xN]0%KF$\"a\u0013(\u0011\u0005aa\u0015BA'\u001a\u0005\u0011)f.\u001b;\t\u000f=C\u0015\u0011!a\u0001\u0001\u0006\u0019\u0001\u0010J\u0019\t\rE\u0003\u0001\u0015)\u0003A\u0003%)\u00070Z2vi>\u0014\b\u0005\u000b\u0002Q'B\u0011\u0001\u0004V\u0005\u0003+f\u0011\u0001B^8mCRLG.\u001a\u0005\b/\u0002\u0011\r\u0011\"\u0003Y\u0003E\u00198\r[3ek2,'\u000f\u00165sK\u0006$\u0017\nZ\u000b\u00023B\u0011!,X\u0007\u00027*\u0011ALQ\u0001\u0007CR|W.[2\n\u0005y[&!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u0004a\u0001\u0001\u0006I!W\u0001\u0013g\u000eDW\rZ;mKJ$\u0006N]3bI&#\u0007\u0005C\u0003c\u0001\u0011\u00053-A\u0004ti\u0006\u0014H/\u001e9\u0015\u0003-CQ!\u001a\u0001\u0005B\r\f\u0001b\u001d5vi\u0012|wO\u001c\u0005\u0006O\u0002!\t\u0001[\u0001\tg\u000eDW\rZ;mKR11*[6qk^DQA\u001b4A\u0002!\nAA\\1nK\")AN\u001aa\u0001[\u0006\u0019a-\u001e8\u0011\u0007aq7*\u0003\u0002p3\tIa)\u001e8di&|g\u000e\r\u0005\bc\u001a\u0004\n\u00111\u0001s\u0003\u0015!W\r\\1z!\tA2/\u0003\u0002u3\t!Aj\u001c8h\u0011\u001d1h\r%AA\u0002I\fa\u0001]3sS>$\u0007b\u0002=g!\u0003\u0005\r!_\u0001\u0005k:LG\u000f\u0005\u0002Bu&\u00111P\u0011\u0002\t)&lW-\u00168ji\")Q\u0010\u0001C\u0005}\u0006iQM\\:ve\u0016\u001cF/\u0019:uK\u0012,\u0012a\u0013\u0015\u0004\u0001\u0005\u0005\u0001cA\t\u0002\u0004%\u0019\u0011Q\u0001\u0002\u0003\u0015QD'/Z1eg\u00064WmB\u0005\u0002\n\t\t\t\u0011#\u0002\u0002\f\u0005q1*\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\bcA\t\u0002\u000e\u0019A\u0011AAA\u0001\u0012\u000b\tya\u0005\u0003\u0002\u000e!9\u0002bB\u001c\u0002\u000e\u0011\u0005\u00111\u0003\u000b\u0003\u0003\u0017A!\"a\u0006\u0002\u000eE\u0005I\u0011AA\r\u00039Ig.\u001b;%I\u00164\u0017-\u001e7uII*\"!a\u0007+\u0007!\nib\u000b\u0002\u0002 A!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012!C;oG\",7m[3e\u0015\r\tI#G\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0017\u0003G\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\t\t$!\u0004\u0012\u0002\u0013\u0005\u00111G\u0001\u000fS:LG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t)DK\u00024\u0003;\u0001")
public class KafkaScheduler
implements Scheduler,
Logging {
    private final int threads;
    private final String threadNamePrefix;
    public final boolean kafka$utils$KafkaScheduler$$daemon;
    private volatile ScheduledThreadPoolExecutor executor;
    private final AtomicInteger kafka$utils$KafkaScheduler$$schedulerThreadId;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final boolean init$default$3() {
        return KafkaScheduler$.MODULE$.init$default$3();
    }

    public static final String init$default$2() {
        return KafkaScheduler$.MODULE$.init$default$2();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        KafkaScheduler kafkaScheduler = this;
        synchronized (kafkaScheduler) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    @Override
    public long schedule$default$3() {
        return Scheduler$class.schedule$default$3(this);
    }

    @Override
    public long schedule$default$4() {
        return Scheduler$class.schedule$default$4(this);
    }

    @Override
    public TimeUnit schedule$default$5() {
        return Scheduler$class.schedule$default$5(this);
    }

    public int threads() {
        return this.threads;
    }

    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private ScheduledThreadPoolExecutor executor() {
        return this.executor;
    }

    private void executor_$eq(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        this.executor = scheduledThreadPoolExecutor;
    }

    public final AtomicInteger kafka$utils$KafkaScheduler$$schedulerThreadId() {
        return this.kafka$utils$KafkaScheduler$$schedulerThreadId;
    }

    @Override
    public void startup() {
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Initializing task scheduler.";
            }
        }));
        KafkaScheduler kafkaScheduler = this;
        synchronized (kafkaScheduler) {
            if (this.executor() == null) {
                this.executor_$eq(new ScheduledThreadPoolExecutor(this.threads()));
                this.executor().setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
                this.executor().setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
                this.executor().setThreadFactory(new ThreadFactory(this){
                    private final KafkaScheduler $outer;

                    public Thread newThread(Runnable runnable) {
                        return Utils$.MODULE$.newThread(new StringBuilder().append((Object)this.$outer.threadNamePrefix()).append(BoxesRunTime.boxToInteger(this.$outer.kafka$utils$KafkaScheduler$$schedulerThreadId().getAndIncrement())).toString(), runnable, this.$outer.kafka$utils$KafkaScheduler$$daemon);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                return;
            }
            throw new IllegalStateException("This scheduler has already been started!");
        }
    }

    @Override
    public void shutdown() {
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutting down task scheduler.";
            }
        }));
        this.ensureStarted();
        this.executor().shutdown();
        this.executor().awaitTermination(1L, TimeUnit.DAYS);
        this.executor_$eq(null);
    }

    @Override
    public void schedule(String name$1, Function0<BoxedUnit> fun$1, long delay$1, long period$1, TimeUnit unit$1) {
        this.debug((Function0<String>)((Object)new Serializable(this, name$1, delay$1, period$1, unit$1){
            public static final long serialVersionUID;
            private final String name$1;
            private final long delay$1;
            private final long period$1;
            private final TimeUnit unit$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Scheduling task %s with initial delay %d ms and period %d ms.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.name$1, BoxesRunTime.boxToLong(TimeUnit.MILLISECONDS.convert(this.delay$1, this.unit$1)), BoxesRunTime.boxToLong(TimeUnit.MILLISECONDS.convert(this.period$1, this.unit$1))}));
            }
            {
                this.name$1 = string2;
                this.delay$1 = l;
                this.period$1 = l2;
                this.unit$1 = timeUnit;
            }
        }));
        this.ensureStarted();
        Runnable runnable = new Runnable(this, name$1, fun$1){
            private final KafkaScheduler $outer;
            public final String name$1;
            private final Function0 fun$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    this.$outer.trace((Function0<String>)((Object)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anon$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Begining execution of scheduled task '%s'.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.name$1}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                    this.fun$1.apply$mcV$sp();
                    this.$outer.trace((Function0<String>)((Object)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anon$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Completed execution of scheduled task '%s'.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.name$1}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                    return;
                }
                catch (Throwable throwable) {
                    try {
                        this.$outer.error((Function0<String>)((Object)new Serializable(this){
                            public static final long serialVersionUID;
                            private final $anon$1 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Uncaught exception in scheduled task '").append((Object)this.$outer.name$1).append((Object)"'").toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                            public static final long serialVersionUID;
                            private final Throwable t$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Throwable apply() {
                                return this.t$1;
                            }
                            {
                                this.t$1 = throwable;
                            }
                        }));
                        this.$outer.trace((Function0<String>)((Object)new /* invalid duplicate definition of identical inner class */));
                        return;
                    }
                    catch (Throwable throwable2) {
                        this.$outer.trace((Function0<String>)((Object)new /* invalid duplicate definition of identical inner class */));
                        throw throwable2;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.name$1 = string2;
                this.fun$1 = function0;
            }
        };
        if (period$1 >= 0L) {
            this.executor().scheduleAtFixedRate(runnable, delay$1, period$1, unit$1);
        } else {
            this.executor().schedule(runnable, delay$1, unit$1);
        }
    }

    private void ensureStarted() {
        if (this.executor() == null) {
            throw new IllegalStateException("Kafka scheduler has not been started");
        }
    }

    public KafkaScheduler(int threads, String threadNamePrefix, boolean daemon) {
        this.threads = threads;
        this.threadNamePrefix = threadNamePrefix;
        this.kafka$utils$KafkaScheduler$$daemon = daemon;
        Scheduler$class.$init$(this);
        Logging$class.$init$(this);
        this.executor = null;
        this.kafka$utils$KafkaScheduler$$schedulerThreadId = new AtomicInteger(0);
    }
}

