/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.cluster.Broker;
import kafka.common.KafkaException;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.SimpleConsumer;
import kafka.utils.Utils$;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;

public final class UpdateOffsetsInZK$
implements ScalaObject {
    public static final UpdateOffsetsInZK$ MODULE$;
    private final String Earliest;
    private final String Latest;

    static {
        new UpdateOffsetsInZK$();
    }

    public String Earliest() {
        return this.Earliest;
    }

    public String Latest() {
        return this.Latest;
    }

    public void main(String[] args) {
        if (args.length < 3) {
            this.usage();
        }
        ConsumerConfig config = new ConsumerConfig(Utils$.MODULE$.loadProps(args[1]));
        ZkClient zkClient = new ZkClient(config.zkConnect(), config.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), ZKStringSerializer$.MODULE$);
        String string2 = args[0];
        String string3 = this.Earliest();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.getAndSetOffsets(zkClient, OffsetRequest$.MODULE$.EarliestTime(), config, args[2]);
        } else {
            String string5 = this.Latest();
            String string6 = string2;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                this.getAndSetOffsets(zkClient, OffsetRequest$.MODULE$.LatestTime(), config, args[2]);
            } else {
                this.usage();
            }
        }
    }

    private void getAndSetOffsets(ZkClient zkClient$1, long offsetOption$1, ConsumerConfig config$1, String topic$1) {
        Map<String, Seq<Object>> partitionsPerTopicMap = ZkUtils$.MODULE$.getPartitionsForTopics(zkClient$1, (Seq<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1})));
        Seq<Nothing$> partitions = Nil$.MODULE$;
        Option option = partitionsPerTopicMap.get(topic$1);
        if (option instanceof Some) {
            partitions = (Seq)((SeqLike)((Some)option).x()).sortWith(new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(int s, int t) {
                    return this.apply$mcZII$sp(s, t);
                }

                public boolean apply$mcZII$sp(int v1, int v2) {
                    return v1 < v2;
                }
            });
            IntRef numParts$1 = new IntRef(0);
            partitions.foreach(new Serializable(zkClient$1, offsetOption$1, config$1, topic$1, numParts$1){
                public static final long serialVersionUID;
                private final ZkClient zkClient$1;
                private final long offsetOption$1;
                private final ConsumerConfig config$1;
                private final String topic$1;
                private final IntRef numParts$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(int partition2) {
                    this.apply$mcVI$sp(partition2);
                }

                public void apply$mcVI$sp(int v1) {
                    Option<Object> brokerHostingPartition = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient$1, this.topic$1, v1);
                    Option<Object> option = brokerHostingPartition;
                    if (option instanceof Some) {
                        int broker = BoxesRunTime.unboxToInt(((Some)option).x());
                        Option<Broker> option2 = ZkUtils$.MODULE$.getBrokerInfo(this.zkClient$1, broker);
                        if (option2 instanceof Some) {
                            Broker broker2;
                            Some some = (Some)option2;
                            Broker brokerInfo = broker2 = (Broker)some.x();
                            SimpleConsumer consumer = new SimpleConsumer(brokerInfo.host(), brokerInfo.port(), 10000, 102400, "UpdateOffsetsInZk");
                            TopicAndPartition topicAndPartition = new TopicAndPartition(this.topic$1, v1);
                            OffsetRequest request = new OffsetRequest((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(topicAndPartition).$minus$greater(new PartitionOffsetRequestInfo(this.offsetOption$1, 1))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                            long offset = BoxesRunTime.unboxToLong(((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply(topicAndPartition)).offsets().head());
                            ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(this.config$1.groupId(), this.topic$1);
                            Predef$.MODULE$.println(new StringBuilder().append((Object)"updating partition ").append(BoxesRunTime.boxToInteger(v1)).append((Object)" with new offset: ").append(BoxesRunTime.boxToLong(offset)).toString());
                            ZkUtils$.MODULE$.updatePersistentPath(this.zkClient$1, new StringBuilder().append((Object)topicDirs.consumerOffsetDir()).append((Object)"/").append(BoxesRunTime.boxToInteger(v1)).toString(), ((Object)BoxesRunTime.boxToLong(offset)).toString());
                            ++this.numParts$1.elem;
                            return;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Broker> option3 = option2;
                        if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                            throw new KafkaException(Predef$.MODULE$.augmentString("Broker information for broker id %d does not exist in ZK").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(broker)})));
                        }
                        throw new MatchError(option2);
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Object> option4 = option;
                    if (!(none$ != null ? !none$.equals(option4) : option4 != null)) {
                        throw new KafkaException(new StringBuilder().append((Object)"Broker ").append(brokerHostingPartition).append((Object)" is unavailable. Cannot issue ").append((Object)"getOffsetsBefore request").toString());
                    }
                    throw new MatchError(option);
                }
                {
                    this.zkClient$1 = zkClient;
                    this.offsetOption$1 = l;
                    this.config$1 = consumerConfig;
                    this.topic$1 = string2;
                    this.numParts$1 = intRef;
                }
            });
            Predef$.MODULE$.println(new StringBuilder().append((Object)"updated the offset for ").append(BoxesRunTime.boxToInteger(numParts$1.elem)).append((Object)" partitions").toString());
            return;
        }
        throw new RuntimeException(new StringBuilder().append((Object)"Can't find topic ").append((Object)topic$1).toString());
    }

    private void usage() {
        Predef$.MODULE$.println(new StringBuilder().append((Object)"USAGE: ").append((Object)this.getClass().getName()).append((Object)" [earliest | latest] consumer.properties topic").toString());
        System.exit(1);
    }

    private UpdateOffsetsInZK$() {
        MODULE$ = this;
        this.Earliest = "earliest";
        this.Latest = "latest";
    }
}

