/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import kafka.common.Topic$;
import kafka.tools.StateChangeLogMerger;
import kafka.tools.StateChangeLogMerger$dateBasedOrdering$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class StateChangeLogMerger$
implements Logging {
    public static final StateChangeLogMerger$ MODULE$;
    private final String dateFormatString;
    private final Regex topicPartitionRegex;
    private final Regex dateRegex;
    private final SimpleDateFormat dateFormat;
    private List<String> files;
    private String topic;
    private List<Object> partitions;
    private Date startDate;
    private Date endDate;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new StateChangeLogMerger$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        StateChangeLogMerger$ stateChangeLogMerger$ = this;
        synchronized (stateChangeLogMerger$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String dateFormatString() {
        return this.dateFormatString;
    }

    public Regex topicPartitionRegex() {
        return this.topicPartitionRegex;
    }

    public Regex dateRegex() {
        return this.dateRegex;
    }

    public SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    public List<String> files() {
        return this.files;
    }

    public void files_$eq(List<String> list2) {
        this.files = list2;
    }

    public String topic() {
        return this.topic;
    }

    public void topic_$eq(String string2) {
        this.topic = string2;
    }

    public List<Object> partitions() {
        return this.partitions;
    }

    public void partitions_$eq(List<Object> list2) {
        this.partitions = list2;
    }

    public Date startDate() {
        return this.startDate;
    }

    public void startDate_$eq(Date date) {
        this.startDate = date;
    }

    public Date endDate() {
        return this.endDate;
    }

    public void endDate_$eq(Date date) {
        this.endDate = date;
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> filesOpt = parser.accepts("logs", "Comma separated list of state change logs or a regex for the log file names").withRequiredArg().describedAs("file1,file2,...").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> regexOpt = parser.accepts("logs-regex", "Regex to match the state change log files to be merged").withRequiredArg().describedAs("for example: /tmp/state-change.log*").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> topicOpt = parser.accepts("topic", "The topic whose state change logs should be merged").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> partitionsOpt = parser.accepts("partitions", "Comma separated list of partition ids whose state change logs should be merged").withRequiredArg().describedAs("0,1,2,...").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> startTimeOpt = parser.accepts("start-time", "The earliest timestamp of state change log entries to be merged").withRequiredArg().describedAs(new StringBuilder().append((Object)"start timestamp in the format ").append(this.dateFormat()).toString()).ofType(String.class).defaultsTo("0000-00-00 00:00:00,000", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<String> endTimeOpt = parser.accepts("end-time", "The latest timestamp of state change log entries to be merged").withRequiredArg().describedAs(new StringBuilder().append((Object)"end timestamp in the format ").append(this.dateFormat()).toString()).ofType(String.class).defaultsTo("9999-12-31 23:59:59,999", (String[])((Object[])new String[0]));
        OptionSet options = parser.parse(args);
        if (!options.has(filesOpt) && !options.has(regexOpt) || options.has(filesOpt) && options.has(regexOpt)) {
            System.err.println(new StringBuilder().append((Object)"Provide arguments to exactly one of the two options \"").append(filesOpt).append((Object)"\" or \"").append(regexOpt).append((Object)"\"").toString());
            parser.printHelpOn(System.err);
            System.exit(1);
        }
        if (options.has(partitionsOpt) && !options.has(topicOpt)) {
            System.err.println(new StringBuilder().append((Object)"The option \"").append(topicOpt).append((Object)"\" needs to be provided an argument when specifying partition ids").toString());
            parser.printHelpOn(System.err);
            System.exit(1);
        }
        if (options.has(filesOpt)) {
            this.files_$eq(this.files().$colon$colon$colon(Predef$.MODULE$.refArrayOps((Object[])options.valueOf(filesOpt).split(",")).toList()));
        } else if (options.has(regexOpt)) {
            String regex = options.valueOf(regexOpt);
            int fileNameIndex = regex.lastIndexOf(47) + 1;
            String dirName$1 = fileNameIndex == 0 ? "." : regex.substring(0, fileNameIndex - 1);
            Regex fileNameRegex$1 = new Regex(regex.substring(fileNameIndex), Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.files_$eq(this.files().$colon$colon$colon(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new File(dirName$1).listFiles()).filter(new Serializable(fileNameRegex$1){
                public static final long serialVersionUID;
                private final Regex fileNameRegex$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(File f2) {
                    Option<String> option = this.fileNameRegex$1.findFirstIn(f2.getName());
                    None$ none$ = None$.MODULE$;
                    return option != null ? !option.equals(none$) : none$ != null;
                }
                {
                    this.fileNameRegex$1 = regex;
                }
            })).map(new Serializable(dirName$1){
                public static final long serialVersionUID;
                private final String dirName$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(File file) {
                    return new StringBuilder().append((Object)this.dirName$1).append((Object)"/").append((Object)file.getName()).toString();
                }
                {
                    this.dirName$1 = string2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))).toList()));
        }
        if (options.has(topicOpt)) {
            this.topic_$eq(options.valueOf(topicOpt));
        }
        if (options.has(partitionsOpt)) {
            this.partitions_$eq(Predef$.MODULE$.refArrayOps((Object[])options.valueOf(partitionsOpt).split(",")).toList().map(new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(String string2) {
                    return Predef$.MODULE$.augmentString(string2).toInt();
                }
            }, List$.MODULE$.canBuildFrom()));
        }
        this.startDate_$eq(this.dateFormat().parse(options.valueOf(startTimeOpt).replace('\"', ' ').trim()));
        this.endDate_$eq(this.dateFormat().parse(options.valueOf(endTimeOpt).replace('\"', ' ').trim()));
        PriorityQueue<StateChangeLogMerger.LineIterator> pqueue = new PriorityQueue<StateChangeLogMerger.LineIterator>(StateChangeLogMerger$dateBasedOrdering$.MODULE$);
        BufferedOutputStream output2 = new BufferedOutputStream(System.out, 0x100000);
        List lineIterators = this.files().map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Iterator<String> apply(String string2) {
                return Source$.MODULE$.fromFile(string2, Codec$.MODULE$.fallbackSystemCodec()).getLines();
            }
        }, List$.MODULE$.canBuildFrom());
        ObjectRef lines$1 = new ObjectRef(Nil$.MODULE$);
        lineIterators.foreach(new Serializable(lines$1){
            public static final long serialVersionUID;
            private final ObjectRef lines$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Iterator<String> itr) {
                StateChangeLogMerger.LineIterator lineItr = StateChangeLogMerger$.MODULE$.getNextLine(itr);
                if (!lineItr.isEmpty()) {
                    this.lines$1.elem = ((List)this.lines$1.elem).$colon$colon(lineItr);
                }
            }
            {
                this.lines$1 = objectRef;
            }
        });
        if (!((List)lines$1.elem).isEmpty()) {
            pqueue.enqueue((List)lines$1.elem);
        }
        while (true) {
            if (pqueue.isEmpty()) {
                ((OutputStream)output2).flush();
                return;
            }
            StateChangeLogMerger.LineIterator lineItr = pqueue.dequeue();
            ((OutputStream)output2).write(new StringBuilder().append((Object)lineItr.line()).append((Object)"\n").toString().getBytes());
            StateChangeLogMerger.LineIterator nextLineItr = this.getNextLine(lineItr.itr());
            if (nextLineItr.isEmpty()) continue;
            pqueue.enqueue(Predef$.MODULE$.wrapRefArray((Object[])new StateChangeLogMerger.LineIterator[]{nextLineItr}));
        }
    }

    public StateChangeLogMerger.LineIterator getNextLine(Iterator<String> itr) {
        while (itr != null && itr.hasNext()) {
            String nextLine = itr.next();
            Option<String> option = this.dateRegex().findFirstIn(nextLine);
            if (option instanceof Some) {
                String string2;
                Some some = (Some)option;
                String d = string2 = (String)some.x();
                Date date = this.dateFormat().parse(d);
                if (!date.equals(this.startDate()) && !date.after(this.startDate()) || !date.equals(this.endDate()) && !date.before(this.endDate())) continue;
                Option<Regex.Match> option2 = this.topicPartitionRegex().findFirstMatchIn(nextLine);
                if (option2 instanceof Some) {
                    Regex.Match match;
                    Some some2 = (Some)option2;
                    Regex.Match matcher = match = (Regex.Match)some2.x();
                    if (this.topic() != null) {
                        String string3 = this.topic();
                        String string4 = matcher.group(1);
                        if (string3 != null ? !string3.equals(string4) : string4 != null) continue;
                    }
                    if (!this.partitions().isEmpty() && !this.partitions().contains(BoxesRunTime.boxToInteger(Predef$.MODULE$.augmentString(matcher.group(3)).toInt()))) continue;
                    return new StateChangeLogMerger.LineIterator(nextLine, itr);
                }
                None$ none$ = None$.MODULE$;
                Option<Regex.Match> option3 = option2;
                if (!(none$ == null ? option3 != null : !none$.equals(option3))) continue;
                throw new MatchError(option2);
            }
            None$ none$ = None$.MODULE$;
            Option<String> option4 = option;
            if (!(none$ == null ? option4 != null : !none$.equals(option4))) continue;
            throw new MatchError(option);
        }
        return new StateChangeLogMerger.LineIterator();
    }

    private StateChangeLogMerger$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
        this.topicPartitionRegex = new Regex(new StringBuilder().append((Object)"\\[(").append((Object)Topic$.MODULE$.legalChars()).append((Object)"+),( )*([0-9]+)\\]").toString(), Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.dateRegex = new Regex("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2},[0-9]{3}", Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.dateFormat = new SimpleDateFormat(this.dateFormatString());
        this.files = Nil$.MODULE$;
        this.topic = null;
        this.partitions = Nil$.MODULE$;
        this.startDate = null;
        this.endDate = null;
    }
}

