/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.concurrent.CountDownLatch;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.api.FetchResponsePartitionData$;
import kafka.api.Request$;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageSet$;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaVerificationTool$;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import scala.Function0;
import scala.MatchError;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0005\u000f\tq!+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014(BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003\u0015)H/\u001b7t\u0013\ti!B\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0007CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"aC*dC2\fwJ\u00196fGRD\u0011\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u000f\u0002\t9\fW.\u001a\t\u0003/iq!a\u0004\r\n\u0005e\u0001\u0012A\u0002)sK\u0012,g-\u0003\u0002\u001c9\t11\u000b\u001e:j]\u001eT!!\u0007\t\n\u0005Ua\u0001\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u0019M|WO]2f\u0005J|7.\u001a:\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r\"\u0011aB2mkN$XM]\u0005\u0003K\t\u0012aA\u0011:pW\u0016\u0014\b\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002%Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004SE\"dB\u0001\u00160\u001d\tYc&D\u0001-\u0015\tic!\u0001\u0004=e>|GOP\u0005\u0002#%\u0011\u0001\u0007E\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00114G\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\t\u0001\u0004\u0003\u0005\u00026q5\taG\u0003\u00028\t\u000511m\\7n_:L!!\u000f\u001c\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u00035\u0011X\r\u001d7jG\u0006\u0014UO\u001a4feB\u0011QHP\u0007\u0002\u0005%\u0011qH\u0001\u0002\u000e%\u0016\u0004H.[2b\u0005V4g-\u001a:\t\u0011\u0005\u0003!\u0011!Q\u0001\n\t\u000bQb]8dW\u0016$H+[7f_V$\bCA\bD\u0013\t!\u0005CA\u0002J]RD\u0001B\u0012\u0001\u0003\u0002\u0003\u0006IAQ\u0001\u0011g>\u001c7.\u001a;Ck\u001a4WM]*ju\u0016D\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006IAQ\u0001\nM\u0016$8\r[*ju\u0016D\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IAQ\u0001\b[\u0006Dx+Y5u\u0011!a\u0005A!A!\u0002\u0013\u0011\u0015\u0001C7j]\nKH/Z:\t\u00119\u0003!\u0011!Q\u0001\n=\u000ba\u0002Z8WKJLg-[2bi&|g\u000e\u0005\u0002\u0010!&\u0011\u0011\u000b\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0003\u0019a\u0014N\\5u}QYQKV,Y3j[F,\u00180`!\ti\u0004\u0001C\u0003\u0016%\u0002\u0007a\u0003C\u0003 %\u0002\u0007\u0001\u0005C\u0003(%\u0002\u0007\u0001\u0006C\u0003<%\u0002\u0007A\bC\u0003B%\u0002\u0007!\tC\u0003G%\u0002\u0007!\tC\u0003I%\u0002\u0007!\tC\u0003K%\u0002\u0007!\tC\u0003M%\u0002\u0007!\tC\u0003O%\u0002\u0007q\nC\u0004b\u0001\t\u0007I\u0011\u00012\u0002\u001dMLW\u000e\u001d7f\u0007>t7/^7feV\t1\r\u0005\u0002eO6\tQM\u0003\u0002g\t\u0005A1m\u001c8tk6,'/\u0003\u0002iK\nq1+[7qY\u0016\u001cuN\\:v[\u0016\u0014\bB\u00026\u0001A\u0003%1-A\btS6\u0004H.Z\"p]N,X.\u001a:!\u0011\u001da\u0007A1A\u0005\u00025\f1CZ3uG\"\u0014V-];fgR\u0014U/\u001b7eKJ,\u0012A\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c\u0012\t1!\u00199j\u0013\t\u0019\bOA\nGKR\u001c\u0007NU3rk\u0016\u001cHOQ;jY\u0012,'\u000f\u0003\u0004v\u0001\u0001\u0006IA\\\u0001\u0015M\u0016$8\r\u001b*fcV,7\u000f\u001e\"vS2$WM\u001d\u0011\t\u000b]\u0004A\u0011\t=\u0002\r\u0011|wk\u001c:l)\u0005I\bCA\b{\u0013\tY\bC\u0001\u0003V]&$\b")
public class ReplicaFetcher
extends ShutdownableThread
implements ScalaObject {
    public final Broker kafka$tools$ReplicaFetcher$$sourceBroker;
    private final Iterable<TopicAndPartition> topicAndPartitions;
    public final ReplicaBuffer kafka$tools$ReplicaFetcher$$replicaBuffer;
    public final int kafka$tools$ReplicaFetcher$$fetchSize;
    private final boolean doVerification;
    private final SimpleConsumer simpleConsumer;
    private final FetchRequestBuilder fetchRequestBuilder;

    public SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    public FetchRequestBuilder fetchRequestBuilder() {
        return this.fetchRequestBuilder;
    }

    @Override
    public void doWork() {
        CountDownLatch verificationBarrier;
        CountDownLatch fetcherBarrier;
        block5: {
            FetchResponse response;
            block4: {
                fetcherBarrier = this.kafka$tools$ReplicaFetcher$$replicaBuffer.getFetcherBarrier();
                verificationBarrier = this.kafka$tools$ReplicaFetcher$$replicaBuffer.getVerificationBarrier();
                this.topicAndPartitions.foreach(new Serializable(this){
                    public static final long serialVersionUID;
                    private final ReplicaFetcher $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final FetchRequestBuilder apply(TopicAndPartition topicAndPartition) {
                        return this.$outer.fetchRequestBuilder().addFetch(topicAndPartition.topic(), topicAndPartition.partition(), this.$outer.kafka$tools$ReplicaFetcher$$replicaBuffer.getOffset(topicAndPartition), this.$outer.kafka$tools$ReplicaFetcher$$fetchSize);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                FetchRequest fetchRequest$1 = this.fetchRequestBuilder().build();
                this.debug((Function0<String>)((Object)new Serializable(this, fetchRequest$1){
                    public static final long serialVersionUID;
                    private final FetchRequest fetchRequest$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Issuing fetch request ").append(this.fetchRequest$1).toString();
                    }
                    {
                        this.fetchRequest$1 = fetchRequest;
                    }
                }));
                response = null;
                try {
                    response = this.simpleConsumer().fetch(fetchRequest$1);
                }
                finally {
                    if (response != null) break block4;
                }
                this.topicAndPartitions.foreach(new Serializable(this){
                    public static final long serialVersionUID;
                    private final ReplicaFetcher $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(TopicAndPartition topicAndPartition) {
                        ByteBufferMessageSet x$9 = MessageSet$.MODULE$.Empty();
                        short x$10 = FetchResponsePartitionData$.MODULE$.init$default$1();
                        long x$11 = FetchResponsePartitionData$.MODULE$.init$default$2();
                        this.$outer.kafka$tools$ReplicaFetcher$$replicaBuffer.addFetchedData(topicAndPartition, this.$outer.kafka$tools$ReplicaFetcher$$sourceBroker.id(), new FetchResponsePartitionData(x$10, x$11, x$9));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                break block5;
            }
            response.data().foreach(new Serializable(this){
                public static final long serialVersionUID;
                private final ReplicaFetcher $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<TopicAndPartition, FetchResponsePartitionData> tuple2) {
                    Tuple2<TopicAndPartition, FetchResponsePartitionData> tuple22 = tuple2;
                    if (tuple22 != null) {
                        this.$outer.kafka$tools$ReplicaFetcher$$replicaBuffer.addFetchedData(tuple22._1(), this.$outer.kafka$tools$ReplicaFetcher$$sourceBroker.id(), tuple22._2());
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        fetcherBarrier.countDown();
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Done fetching";
            }
        }));
        fetcherBarrier.await();
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Ready for verification";
            }
        }));
        if (this.doVerification) {
            this.debug((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Do verification";
                }
            }));
            this.kafka$tools$ReplicaFetcher$$replicaBuffer.verifyCheckSum();
            this.kafka$tools$ReplicaFetcher$$replicaBuffer.createNewFetcherBarrier();
            this.kafka$tools$ReplicaFetcher$$replicaBuffer.createNewVerificationBarrier();
            this.debug((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Created new barrier";
                }
            }));
            verificationBarrier.countDown();
        }
        verificationBarrier.await();
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Done verification";
            }
        }));
    }

    public ReplicaFetcher(String name, Broker sourceBroker, Iterable<TopicAndPartition> topicAndPartitions, ReplicaBuffer replicaBuffer, int socketTimeout, int socketBufferSize, int fetchSize, int maxWait, int minBytes, boolean doVerification) {
        this.kafka$tools$ReplicaFetcher$$sourceBroker = sourceBroker;
        this.topicAndPartitions = topicAndPartitions;
        this.kafka$tools$ReplicaFetcher$$replicaBuffer = replicaBuffer;
        this.kafka$tools$ReplicaFetcher$$fetchSize = fetchSize;
        this.doVerification = doVerification;
        super(name, ShutdownableThread$.MODULE$.init$default$2());
        this.simpleConsumer = new SimpleConsumer(sourceBroker.host(), sourceBroker.port(), socketTimeout, socketBufferSize, ReplicaVerificationTool$.MODULE$.clientId());
        this.fetchRequestBuilder = new FetchRequestBuilder().clientId(ReplicaVerificationTool$.MODULE$.clientId()).replicaId(Request$.MODULE$.DebuggingConsumerId()).maxWait(maxWait).minBytes(minBytes);
    }
}

