/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionMetadata;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.utils.CommandLineUtils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class GetOffsetShell$
implements ScalaObject {
    public static final GetOffsetShell$ MODULE$;

    static {
        new GetOffsetShell$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> topicOpt = parser.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> partitionOpt = parser.accepts("partitions", "comma separated list of partition ids. If not specified, it will find offsets for all partitions").withRequiredArg().describedAs("partition ids").ofType(String.class).defaultsTo("", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<Long> timeOpt = parser.accepts("time", "timestamp of the offsets before that").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class);
        ArgumentAcceptingOptionSpec<Integer> nOffsetsOpt = parser.accepts("offsets", "number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1000), (Integer[])((Object[])new Integer[0]));
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt, topicOpt, timeOpt}));
        String clientId$1 = "GetOffsetShell";
        Seq<Broker> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList(options.valueOf(brokerListOpt));
        String topic$1 = options.valueOf(topicOpt);
        String partitionList = options.valueOf(partitionOpt);
        LongRef time$1 = new LongRef(options.valueOf(timeOpt));
        int nOffsets$1 = options.valueOf(nOffsetsOpt);
        int maxWaitMs = options.valueOf(maxWaitMsOpt);
        Seq<TopicMetadata> topicsMetadata$1 = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1})), metadataTargetBrokers, clientId$1, maxWaitMs, ClientUtils$.MODULE$.fetchTopicMetadata$default$5()).topicsMetadata();
        if (topicsMetadata$1.size() != 1 || !((TopicMetadata)topicsMetadata$1.apply(0)).topic().equals(topic$1)) {
            System.err.println(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Error: no valid topic metadata for topic: %s,  probably the topic does not exist, run ").format(Predef$.MODULE$.genericWrapArray(new Object[]{topic$1}))).append((Object)"kafka-list-topic.sh to verify").toString());
            System.exit(1);
        }
        String string2 = partitionList;
        String string3 = "";
        Seq<Object> partitions = !(string2 != null ? !string2.equals(string3) : string3 != null) ? ((TopicMetadata)topicsMetadata$1.head()).partitionsMetadata().map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(PartitionMetadata partitionMetadata) {
                return partitionMetadata.partitionId();
            }
        }, Seq$.MODULE$.canBuildFrom()) : Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])partitionList.split(",")).map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(String string2) {
                return Predef$.MODULE$.augmentString(string2).toInt();
            }
        }, Array$.MODULE$.canBuildFrom(Manifest$.MODULE$.Int()))).toSeq();
        partitions.foreach(new Serializable(clientId$1, topic$1, time$1, nOffsets$1, topicsMetadata$1){
            public static final long serialVersionUID;
            private final String clientId$1;
            private final String topic$1;
            private final LongRef time$1;
            private final int nOffsets$1;
            private final Seq topicsMetadata$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int v1$1) {
                Option<A> option;
                block6: {
                    block4: {
                        block2: {
                            Option<Broker> option2;
                            block5: {
                                block3: {
                                    Broker broker;
                                    Option<A> partitionMetadataOpt = ((TopicMetadata)this.topicsMetadata$1.head()).partitionsMetadata().find((Function1<PartitionMetadata, Object>)((Object)new Serializable(this, v1$1){
                                        public static final long serialVersionUID;
                                        private final int v1$1;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final boolean apply(PartitionMetadata partitionMetadata) {
                                            return partitionMetadata.partitionId() == this.v1$1;
                                        }
                                        {
                                            this.v1$1 = n;
                                        }
                                    }));
                                    option = partitionMetadataOpt;
                                    if (!(option instanceof Some)) break block2;
                                    Some some = (Some)option;
                                    PartitionMetadata partitionMetadata = (PartitionMetadata)some.x();
                                    PartitionMetadata metadata = partitionMetadata;
                                    option2 = metadata.leader();
                                    if (!(option2 instanceof Some)) break block3;
                                    Some some2 = (Some)option2;
                                    Broker leader = broker = (Broker)some2.x();
                                    SimpleConsumer consumer = new SimpleConsumer(leader.host(), leader.port(), 10000, 100000, this.clientId$1);
                                    TopicAndPartition topicAndPartition = new TopicAndPartition(this.topic$1, v1$1);
                                    OffsetRequest request = new OffsetRequest((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(topicAndPartition).$minus$greater(new PartitionOffsetRequestInfo(this.time$1.elem, this.nOffsets$1))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                                    Seq<Object> offsets = ((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply(topicAndPartition)).offsets();
                                    Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%s:%d:%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, BoxesRunTime.boxToInteger(v1$1), offsets.mkString(",")})));
                                    break block4;
                                }
                                None$ none$ = None$.MODULE$;
                                Option<Broker> option3 = option2;
                                if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                                System.err.println(Predef$.MODULE$.augmentString("Error: partition %d does not have a leader. Skip getting offsets").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(v1$1)})));
                                break block4;
                            }
                            throw new MatchError(option2);
                        }
                        None$ none$ = None$.MODULE$;
                        Option<A> option4 = option;
                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block6;
                        System.err.println(Predef$.MODULE$.augmentString("Error: partition %d does not exist").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(v1$1)})));
                    }
                    return;
                }
                throw new MatchError(option);
            }
            {
                this.clientId$1 = string2;
                this.topic$1 = string3;
                this.time$1 = longRef;
                this.nOffsets$1 = n;
                this.topicsMetadata$1 = seq2;
            }
        });
    }

    private GetOffsetShell$() {
        MODULE$ = this;
    }
}

