/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.api.FetchResponsePartitionData;
import kafka.api.OffsetRequest$;
import kafka.cluster.Broker;
import kafka.cluster.Replica;
import kafka.common.KafkaStorageException;
import kafka.common.TopicAndPartition;
import kafka.message.ByteBufferMessageSet;
import kafka.server.AbstractFetcherThread;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u000f\t!\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012T!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!a\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\u0004\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u00111bU2bY\u0006|%M[3di\"I1\u0003\u0001B\u0001B\u0003%AcG\u0001\u0005]\u0006lW\r\u0005\u0002\u001619\u0011QBF\u0005\u0003/9\ta\u0001\u0015:fI\u00164\u0017BA\r\u001b\u0005\u0019\u0019FO]5oO*\u0011qCD\u0005\u0003'qI!!\b\u0010\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0006\u0003?\u0011\tQ!\u001e;jYND\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003K\u0011\tqa\u00197vgR,'/\u0003\u0002(I\t1!I]8lKJD\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003\u0013-J!\u0001\f\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\t]\u0001\u0011\t\u0011)A\u0005_\u0005Q!/\u001a9mS\u000e\fWj\u001a:\u0011\u0005%\u0001\u0014BA\u0019\u0003\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDQa\r\u0001\u0005\u0002Q\na\u0001P5oSRtD#B\u001b7oaJ\u0004CA\u0005\u0001\u0011\u0015\u0019\"\u00071\u0001\u0015\u0011\u0015\t#\u00071\u0001#\u0011\u0015I#\u00071\u0001+\u0011\u0015q#\u00071\u00010\u0011\u0015Y\u0004\u0001\"\u0001=\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCR!Q\b\u0011%N!\tia(\u0003\u0002@\u001d\t!QK\\5u\u0011\u0015\t%\b1\u0001C\u0003E!x\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b\u0012\taaY8n[>t\u0017BA$E\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\u0006\u0013j\u0002\rAS\u0001\fM\u0016$8\r[(gMN,G\u000f\u0005\u0002\u000e\u0017&\u0011AJ\u0004\u0002\u0005\u0019>tw\rC\u0003Ou\u0001\u0007q*A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0003!Nk\u0011!\u0015\u0006\u0003%\u0012\t1!\u00199j\u0013\t!\u0016K\u0001\u000eGKR\u001c\u0007NU3ta>t7/\u001a)beRLG/[8o\t\u0006$\u0018\rC\u0003W\u0001\u0011\u0005q+\u0001\fiC:$G.Z(gMN,GoT;u\u001f\u001a\u0014\u0016M\\4f)\tQ\u0005\fC\u0003B+\u0002\u0007!\tC\u0003[\u0001\u0011\u00051,\u0001\u000eiC:$G.\u001a)beRLG/[8og^KG\u000f[#se>\u00148\u000f\u0006\u0002>9\")Q,\u0017a\u0001=\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\u0007};'I\u0004\u0002aK:\u0011\u0011\rZ\u0007\u0002E*\u00111MB\u0001\u0007yI|w\u000e\u001e \n\u0003=I!A\u001a\b\u0002\u000fA\f7m[1hK&\u0011\u0001.\u001b\u0002\t\u0013R,'/\u00192mK*\u0011aM\u0004")
public class ReplicaFetcherThread
extends AbstractFetcherThread
implements ScalaObject {
    public final Broker kafka$server$ReplicaFetcherThread$$sourceBroker;
    public final KafkaConfig kafka$server$ReplicaFetcherThread$$brokerConfig;
    private final ReplicaManager replicaMgr;

    @Override
    public void processPartitionData(TopicAndPartition topicAndPartition$1, long fetchOffset, FetchResponsePartitionData partitionData$1) {
        try {
            String topic$1 = topicAndPartition$1.topic();
            int partitionId$1 = topicAndPartition$1.partition();
            Replica replica$1 = this.replicaMgr.getReplica(topic$1, partitionId$1, this.replicaMgr.getReplica$default$3()).get();
            ByteBufferMessageSet messageSet$1 = (ByteBufferMessageSet)partitionData$1.messages();
            if (fetchOffset != replica$1.logEndOffset()) {
                throw new RuntimeException(Predef$.MODULE$.augmentString("Offset mismatch: fetched offset = %d, log end offset = %d.").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(fetchOffset), BoxesRunTime.boxToLong(replica$1.logEndOffset())})));
            }
            this.trace((Function0<String>)((Object)new Serializable(this, topicAndPartition$1, partitionData$1, replica$1, messageSet$1){
                public static final long serialVersionUID;
                private final TopicAndPartition topicAndPartition$1;
                private final FetchResponsePartitionData partitionData$1;
                private final Replica replica$1;
                private final ByteBufferMessageSet messageSet$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Follower %d has replica log end offset %d for partition %s. Received %d messages and leader hw %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.replica$1.brokerId()), BoxesRunTime.boxToLong(this.replica$1.logEndOffset()), this.topicAndPartition$1, BoxesRunTime.boxToInteger(this.messageSet$1.sizeInBytes()), BoxesRunTime.boxToLong(this.partitionData$1.hw())}));
                }
                {
                    this.topicAndPartition$1 = topicAndPartition;
                    this.partitionData$1 = fetchResponsePartitionData;
                    this.replica$1 = replica;
                    this.messageSet$1 = byteBufferMessageSet;
                }
            }));
            replica$1.log().get().append(messageSet$1, false);
            this.trace((Function0<String>)((Object)new Serializable(this, topicAndPartition$1, replica$1, messageSet$1){
                public static final long serialVersionUID;
                private final TopicAndPartition topicAndPartition$1;
                private final Replica replica$1;
                private final ByteBufferMessageSet messageSet$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Follower %d has replica log end offset %d after appending %d bytes of messages for partition %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.replica$1.brokerId()), BoxesRunTime.boxToLong(this.replica$1.logEndOffset()), BoxesRunTime.boxToInteger(this.messageSet$1.sizeInBytes()), this.topicAndPartition$1}));
                }
                {
                    this.topicAndPartition$1 = topicAndPartition;
                    this.replica$1 = replica;
                    this.messageSet$1 = byteBufferMessageSet;
                }
            }));
            long followerHighWatermark$1 = BoxesRunTime.unboxToLong(Predef$.MODULE$.longWrapper(replica$1.logEndOffset()).min(BoxesRunTime.boxToLong(partitionData$1.hw())));
            replica$1.highWatermark_$eq(followerHighWatermark$1);
            this.trace((Function0<String>)((Object)new Serializable(this, topic$1, partitionId$1, replica$1, followerHighWatermark$1){
                public static final long serialVersionUID;
                private final String topic$1;
                private final int partitionId$1;
                private final Replica replica$1;
                private final long followerHighWatermark$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Follower %d set replica highwatermark for partition [%s,%d] to %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.replica$1.brokerId()), this.topic$1, BoxesRunTime.boxToInteger(this.partitionId$1), BoxesRunTime.boxToLong(this.followerHighWatermark$1)}));
                }
                {
                    this.topic$1 = string2;
                    this.partitionId$1 = n;
                    this.replica$1 = replica;
                    this.followerHighWatermark$1 = l;
                }
            }));
        }
        catch (KafkaStorageException kafkaStorageException) {
            this.fatal((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Disk error while replicating data.";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, kafkaStorageException){
                public static final long serialVersionUID;
                private final KafkaStorageException e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final KafkaStorageException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = kafkaStorageException;
                }
            }));
            Runtime.getRuntime().halt(1);
        }
    }

    @Override
    public long handleOffsetOutOfRange(TopicAndPartition topicAndPartition$2) {
        long l;
        Replica replica = this.replicaMgr.getReplica(topicAndPartition$2.topic(), topicAndPartition$2.partition(), this.replicaMgr.getReplica$default$3()).get();
        long leaderEndOffset$1 = this.simpleConsumer().earliestOrLatestOffset(topicAndPartition$2, OffsetRequest$.MODULE$.LatestTime(), this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId());
        if (leaderEndOffset$1 < replica.logEndOffset()) {
            this.replicaMgr.logManager().truncateTo((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(topicAndPartition$2).$minus$greater(BoxesRunTime.boxToLong(leaderEndOffset$1))})));
            this.warn((Function0<String>)((Object)new Serializable(this, topicAndPartition$2, leaderEndOffset$1){
                public static final long serialVersionUID;
                private final ReplicaFetcherThread $outer;
                private final TopicAndPartition topicAndPartition$2;
                private final long leaderEndOffset$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Replica %d for partition %s reset its fetch offset to current leader %d's latest offset %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId()), this.topicAndPartition$2, BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$sourceBroker.id()), BoxesRunTime.boxToLong(this.leaderEndOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.topicAndPartition$2 = topicAndPartition;
                    this.leaderEndOffset$1 = l;
                }
            }));
            l = leaderEndOffset$1;
        } else {
            long leaderStartOffset$1 = this.simpleConsumer().earliestOrLatestOffset(topicAndPartition$2, OffsetRequest$.MODULE$.EarliestTime(), this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId());
            this.replicaMgr.logManager().truncateFullyAndStartAt(topicAndPartition$2, leaderStartOffset$1);
            this.warn((Function0<String>)((Object)new Serializable(this, topicAndPartition$2, leaderStartOffset$1){
                public static final long serialVersionUID;
                private final ReplicaFetcherThread $outer;
                private final TopicAndPartition topicAndPartition$2;
                private final long leaderStartOffset$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Replica %d for partition %s reset its fetch offset to current leader %d's start offset %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId()), this.topicAndPartition$2, BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$sourceBroker.id()), BoxesRunTime.boxToLong(this.leaderStartOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.topicAndPartition$2 = topicAndPartition;
                    this.leaderStartOffset$1 = l;
                }
            }));
            l = leaderStartOffset$1;
        }
        return l;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicAndPartition> partitions) {
    }

    public ReplicaFetcherThread(String name, Broker sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr) {
        this.kafka$server$ReplicaFetcherThread$$sourceBroker = sourceBroker;
        this.kafka$server$ReplicaFetcherThread$$brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        super(name, name, sourceBroker, brokerConfig.replicaSocketTimeoutMs(), brokerConfig.replicaSocketReceiveBufferBytes(), brokerConfig.replicaFetchMaxBytes(), brokerConfig.brokerId(), brokerConfig.replicaFetchWaitMaxMs(), brokerConfig.replicaFetchMinBytes(), false);
    }
}

