/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.common.KafkaException;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.InvalidMessageException;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001\u001d\u0011aBR5mK6+7o]1hKN+GO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u00119!\u0002CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003\u001diWm]:bO\u0016L!!\u0004\u0006\u0003\u00155+7o]1hKN+G\u000f\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011m\u0001!\u00111A\u0005\u0002q\tAAZ5mKV\tQ\u0004\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005\u0011\u0011n\u001c\u0006\u0002E\u0005!!.\u0019<b\u0013\t!sD\u0001\u0003GS2,\u0007\u0002\u0003\u0014\u0001\u0005\u0003\u0007I\u0011A\u0014\u0002\u0011\u0019LG.Z0%KF$\"\u0001K\u0016\u0011\u0005UI\u0013B\u0001\u0016\u0017\u0005\u0011)f.\u001b;\t\u000f1*\u0013\u0011!a\u0001;\u0005\u0019\u0001\u0010J\u0019\t\u00119\u0002!\u0011!Q!\nu\tQAZ5mK\u0002B#!\f\u0019\u0011\u0005U\t\u0014B\u0001\u001a\u0017\u0005!1x\u000e\\1uS2,\u0007\"\u0003\u001b\u0001\u0005\u000b\u0007I\u0011\u0001\u00026\u0003\u001d\u0019\u0007.\u00198oK2,\u0012A\u000e\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\n\u0001b\u00195b]:,Gn\u001d\u0006\u0003w\u0005\n1A\\5p\u0013\ti\u0004HA\u0006GS2,7\t[1o]\u0016d\u0007\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002\u0011\rD\u0017M\u001c8fY\u0002B\u0011\"\u0011\u0001\u0003\u0006\u0004%\tA\u0001\"\u0002\u000bM$\u0018M\u001d;\u0016\u0003\r\u0003\"!\u0006#\n\u0005\u00153\"aA%oi\"Aq\t\u0001B\u0001B\u0003%1)\u0001\u0004ti\u0006\u0014H\u000f\t\u0005\n\u0013\u0002\u0011)\u0019!C\u0001\u0005\t\u000b1!\u001a8e\u0011!Y\u0005A!A!\u0002\u0013\u0019\u0015\u0001B3oI\u0002B\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IAT\u0001\bSN\u001cF.[2f!\t)r*\u0003\u0002Q-\t9!i\\8mK\u0006t\u0007B\u0002*\u0001\t\u0003!1+\u0001\u0004=S:LGO\u0010\u000b\u0007)Z;\u0006,\u0017.\u0011\u0005U\u0003Q\"\u0001\u0002\t\u000bm\t\u0006\u0019A\u000f\t\u000bQ\n\u0006\u0019\u0001\u001c\t\u000b\u0005\u000b\u0006\u0019A\"\t\u000b%\u000b\u0006\u0019A\"\t\u000b5\u000b\u0006\u0019\u0001(\t\u000fq\u0003!\u0019!C\u0005;\u0006)ql]5{KV\ta\f\u0005\u0002`M6\t\u0001M\u0003\u0002bE\u00061\u0011\r^8nS\u000eT!a\u00193\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002fC\u0005!Q\u000f^5m\u0013\t9\u0007MA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\u0005\u0007S\u0002\u0001\u000b\u0011\u00020\u0002\r}\u001b\u0018N_3!\u0011\u0015\u0011\u0006\u0001\"\u0001l)\r!F.\u001c\u0005\u00067)\u0004\r!\b\u0005\u0006i)\u0004\rA\u000e\u0005\u0006%\u0002!\ta\u001c\u000b\u0003)BDQa\u00078A\u0002uAQA\u0015\u0001\u0005\u0002I$2\u0001V:u\u0011\u0015Y\u0012\u000f1\u0001\u001e\u0011\u0015)\u0018\u000f1\u0001O\u0003\u001diW\u000f^1cY\u0016DQA\u0015\u0001\u0005\u0002]$R\u0001\u0016=zunDQa\u0007<A\u0002uAQ\u0001\u000e<A\u0002YBQ!\u0011<A\u0002\rCQ!\u0013<A\u0002\rCQ! \u0001\u0005\u0002y\fAA]3bIR!Ak`A\u0002\u0011\u0019\t\t\u0001 a\u0001\u0007\u0006A\u0001o\\:ji&|g\u000e\u0003\u0004\u0002\u0006q\u0004\raQ\u0001\u0005g&TX\rC\u0004\u0002\n\u0001!\t!a\u0003\u0002\u0013M,\u0017M]2i\r>\u0014HCBA\u0007\u0003'\ti\u0002E\u0002V\u0003\u001fI1!!\u0005\u0003\u00059yeMZ:fiB{7/\u001b;j_:D\u0001\"!\u0006\u0002\b\u0001\u0007\u0011qC\u0001\ri\u0006\u0014x-\u001a;PM\u001a\u001cX\r\u001e\t\u0004+\u0005e\u0011bAA\u000e-\t!Aj\u001c8h\u0011\u001d\ty\"a\u0002A\u0002\r\u000b\u0001c\u001d;beRLgn\u001a)pg&$\u0018n\u001c8\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u00059qO]5uKR{GcB\"\u0002(\u0005E\u0012Q\u0007\u0005\t\u0003S\t\t\u00031\u0001\u0002,\u0005YA-Z:u\u0007\"\fgN\\3m!\r9\u0014QF\u0005\u0004\u0003_A$\u0001F$bi\",'/\u001b8h\u0005f$Xm\u00115b]:,G\u000e\u0003\u0005\u00024\u0005\u0005\u0002\u0019AA\f\u000359(/\u001b;f!>\u001c\u0018\u000e^5p]\"9\u0011QAA\u0011\u0001\u0004\u0019\u0005bBA\u001d\u0001\u0011\u0005\u00131H\u0001\tSR,'/\u0019;peR\u0011\u0011Q\b\t\u0007\u0003\u007f\ty%!\u0016\u000f\t\u0005\u0005\u00131\n\b\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011q\t\u0004\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0012bAA'-\u00059\u0001/Y2lC\u001e,\u0017\u0002BA)\u0003'\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003\u001b2\u0002cA\u0005\u0002X%\u0019\u0011\u0011\f\u0006\u0003!5+7o]1hK\u0006sGm\u00144gg\u0016$\bbBA\u001d\u0001\u0011\u0005\u0011Q\f\u000b\u0005\u0003{\ty\u0006C\u0004\u0002b\u0005m\u0003\u0019A\"\u0002\u001d5\f\u00070T3tg\u0006<WmU5{K\"9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0014aC:ju\u0016LeNQ=uKN$\u0012a\u0011\u0005\b\u0003W\u0002A\u0011AA7\u0003\u0019\t\u0007\u000f]3oIR\u0019\u0001&a\u001c\t\u0011\u0005E\u0014\u0011\u000ea\u0001\u0003g\n\u0001\"\\3tg\u0006<Wm\u001d\t\u0004\u0013\u0005U\u0014bAA<\u0015\t!\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKRDq!a\u001f\u0001\t\u0003\ti(A\u0003gYV\u001c\b\u000eF\u0001)\u0011\u001d\t\t\t\u0001C\u0001\u0003{\nQa\u00197pg\u0016Dq!!\"\u0001\t\u0003\t9)\u0001\u0004eK2,G/\u001a\u000b\u0002\u001d\"9\u00111\u0012\u0001\u0005\u0002\u00055\u0015A\u0003;sk:\u001c\u0017\r^3U_R\u00191)a$\t\u000f\u0005E\u0015\u0011\u0012a\u0001\u0007\u0006QA/\u0019:hKR\u001c\u0016N_3\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\u0006A!/Z1e\u0013:$x\u000e\u0006\u0004\u0002\u001a\u0006\u0005\u0016Q\u0015\t\u0005\u00037\u000bi*D\u0001;\u0013\r\tyJ\u000f\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\u0002CAR\u0003'\u0003\r!!'\u0002\r\t,hMZ3s\u0011\u001d\t\t!a%A\u0002\rCq!!+\u0001\t\u0003\tY+\u0001\u0005sK:\fW.\u001a+p)\rq\u0015Q\u0016\u0005\b\u0003_\u000b9\u000b1\u0001\u001e\u0003\u00051\u0007f\u0001\u0001\u00024B\u0019q\"!.\n\u0007\u0005]\u0006CA\u0007o_:$\bN]3bIN\fg-\u001a")
public class FileMessageSet
extends MessageSet
implements Logging {
    private volatile File file;
    private final FileChannel channel;
    private final int start;
    private final int end;
    private final AtomicInteger _size;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        FileMessageSet fileMessageSet = this;
        synchronized (fileMessageSet) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File file) {
        this.file = file;
    }

    public FileChannel channel() {
        return this.channel;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    private AtomicInteger _size() {
        return this._size;
    }

    public FileMessageSet read(int position, int size2) {
        if (position < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid position: ").append(BoxesRunTime.boxToInteger(position)).toString());
        }
        if (size2 < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid size: ").append(BoxesRunTime.boxToInteger(size2)).toString());
        }
        return new FileMessageSet(this.file(), this.channel(), this.start() + position, package$.MODULE$.min(this.start() + position + size2, this.sizeInBytes()));
    }

    public OffsetPosition searchFor(long targetOffset, int startingPosition) {
        int position = startingPosition;
        ByteBuffer buffer = ByteBuffer.allocate(MessageSet$.MODULE$.LogOverhead());
        int size2 = this.sizeInBytes();
        while (position + MessageSet$.MODULE$.LogOverhead() < size2) {
            buffer.rewind();
            this.channel().read(buffer, position);
            if (buffer.hasRemaining()) {
                throw new IllegalStateException(Predef$.MODULE$.augmentString("Failed to read complete buffer for targetOffset %d startPosition %d in %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(targetOffset), BoxesRunTime.boxToInteger(startingPosition), this.file().getAbsolutePath()})));
            }
            buffer.rewind();
            long offset = buffer.getLong();
            if (offset >= targetOffset) {
                return new OffsetPosition(offset, position);
            }
            int messageSize = buffer.getInt();
            if (messageSize < Message$.MODULE$.MessageOverhead()) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Invalid message size: ").append(BoxesRunTime.boxToInteger(messageSize)).toString());
            }
            position += MessageSet$.MODULE$.LogOverhead() + messageSize;
        }
        return null;
    }

    @Override
    public int writeTo(GatheringByteChannel destChannel, long writePosition, int size$1) {
        int newSize = package$.MODULE$.min((int)this.channel().size(), this.end()) - this.start();
        if (newSize < this._size().get()) {
            throw new KafkaException(Predef$.MODULE$.augmentString("Size of FileMessageSet %s has been truncated during write: old size %d, new size %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.file().getAbsolutePath(), BoxesRunTime.boxToInteger(this._size().get()), BoxesRunTime.boxToInteger(newSize)})));
        }
        int bytesTransferred$1 = (int)this.channel().transferTo((long)this.start() + writePosition, package$.MODULE$.min(size$1, this.sizeInBytes()), destChannel);
        this.trace((Function0<String>)((Object)new Serializable(this, size$1, bytesTransferred$1){
            public static final long serialVersionUID;
            private final FileMessageSet $outer;
            private final int size$1;
            private final int bytesTransferred$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"FileMessageSet ").append((Object)this.$outer.file().getAbsolutePath()).append((Object)" : bytes transferred : ").append(BoxesRunTime.boxToInteger(this.bytesTransferred$1)).append((Object)" bytes requested for transfer : ").append(BoxesRunTime.boxToInteger(package$.MODULE$.min(this.size$1, this.$outer.sizeInBytes()))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.size$1 = n;
                this.bytesTransferred$1 = n2;
            }
        }));
        return bytesTransferred$1;
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return this.iterator(Integer.MAX_VALUE);
    }

    public Iterator<MessageAndOffset> iterator(int maxMessageSize$1) {
        return new IteratorTemplate<MessageAndOffset>(this, maxMessageSize$1){
            private int location;
            private final ByteBuffer sizeOffsetBuffer;
            private final FileMessageSet $outer;
            private final int maxMessageSize$1;

            private int location() {
                return this.location;
            }

            private void location_$eq(int n) {
                this.location = n;
            }

            private ByteBuffer sizeOffsetBuffer() {
                return this.sizeOffsetBuffer;
            }

            public MessageAndOffset makeNext() {
                if (this.location() >= this.$outer.end()) {
                    return (MessageAndOffset)this.allDone();
                }
                this.sizeOffsetBuffer().rewind();
                this.$outer.channel().read(this.sizeOffsetBuffer(), this.location());
                if (this.sizeOffsetBuffer().hasRemaining()) {
                    return (MessageAndOffset)this.allDone();
                }
                this.sizeOffsetBuffer().rewind();
                long offset = this.sizeOffsetBuffer().getLong();
                int size2 = this.sizeOffsetBuffer().getInt();
                if (size2 < Message$.MODULE$.MinHeaderSize()) {
                    return (MessageAndOffset)this.allDone();
                }
                if (size2 > this.maxMessageSize$1) {
                    throw new InvalidMessageException(Predef$.MODULE$.augmentString("Message size exceeds the largest allowable message size (%d).").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.maxMessageSize$1)})));
                }
                ByteBuffer buffer = ByteBuffer.allocate(size2);
                this.$outer.channel().read(buffer, this.location() + 12);
                if (buffer.hasRemaining()) {
                    return (MessageAndOffset)this.allDone();
                }
                buffer.rewind();
                this.location_$eq(this.location() + (size2 + 12));
                return new MessageAndOffset(new Message(buffer), offset);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.maxMessageSize$1 = n;
                this.location = $outer.start();
                this.sizeOffsetBuffer = ByteBuffer.allocate(12);
            }
        };
    }

    @Override
    public int sizeInBytes() {
        return this._size().get();
    }

    public void append(ByteBufferMessageSet messages) {
        int written = messages.writeTo(this.channel(), 0L, messages.sizeInBytes());
        this._size().getAndAdd(written);
    }

    public void flush() {
        this.channel().force(true);
    }

    public void close() {
        this.flush();
        this.channel().close();
    }

    public boolean delete() {
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final FileMessageSet $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.channel().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        return this.file().delete();
    }

    public int truncateTo(int targetSize) {
        int originalSize = this.sizeInBytes();
        if (targetSize > originalSize || targetSize < 0) {
            throw new KafkaException(new StringBuilder().append((Object)"Attempt to truncate log segment to ").append(BoxesRunTime.boxToInteger(targetSize)).append((Object)" bytes failed, ").append((Object)" size of this log segment is ").append(BoxesRunTime.boxToInteger(originalSize)).append((Object)" bytes.").toString());
        }
        this.channel().truncate(targetSize);
        this.channel().position(targetSize);
        this._size().set(targetSize);
        return originalSize - targetSize;
    }

    public ByteBuffer readInto(ByteBuffer buffer, int position) {
        this.channel().read(buffer, position);
        buffer.flip();
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    public boolean renameTo(File f2) {
        void var2_2;
        boolean success2 = this.file().renameTo(f2);
        this.file_$eq(f2);
        return (boolean)var2_2;
    }

    public FileMessageSet(File file, FileChannel channel, int start, int end, boolean isSlice) {
        this.file = file;
        this.channel = channel;
        this.start = start;
        this.end = end;
        Logging$class.$init$(this);
        this._size = isSlice ? new AtomicInteger(end - start) : new AtomicInteger(package$.MODULE$.min((int)channel.size(), end) - start);
        Object object = isSlice ? BoxedUnit.UNIT : channel.position(channel.size());
    }

    public FileMessageSet(File file, FileChannel channel) {
        this(file, channel, 0, Integer.MAX_VALUE, false);
    }

    public FileMessageSet(File file) {
        this(file, Utils$.MODULE$.openChannel(file, true));
    }

    public FileMessageSet(File file, boolean mutable) {
        this(file, Utils$.MODULE$.openChannel(file, mutable));
    }

    public FileMessageSet(File file, FileChannel channel, int start, int end) {
        this(file, channel, start, end, true);
    }
}

