/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.nio.ByteBuffer;
import kafka.common.BrokerNotAvailableException;
import kafka.common.ControllerMovedException;
import kafka.common.ErrorMapping$;
import kafka.common.InvalidMessageSizeException;
import kafka.common.LeaderNotAvailableException;
import kafka.common.MessageSizeTooLargeException;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.OffsetMetadataTooLargeException;
import kafka.common.OffsetOutOfRangeException;
import kafka.common.ReplicaNotAvailableException;
import kafka.common.RequestTimedOutException;
import kafka.common.UnknownException;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.message.InvalidMessageException;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ErrorMapping$
implements ScalaObject {
    public static final ErrorMapping$ MODULE$;
    private final ByteBuffer EmptyByteBuffer;
    private final short UnknownCode;
    private final short NoError;
    private final short OffsetOutOfRangeCode;
    private final short InvalidMessageCode;
    private final short UnknownTopicOrPartitionCode;
    private final short InvalidFetchSizeCode;
    private final short LeaderNotAvailableCode;
    private final short NotLeaderForPartitionCode;
    private final short RequestTimedOutCode;
    private final short BrokerNotAvailableCode;
    private final short ReplicaNotAvailableCode;
    private final short MessageSizeTooLargeCode;
    private final short StaleControllerEpochCode;
    private final short OffsetMetadataTooLargeCode;
    private final short StaleLeaderEpochCode;
    private final Map<Class<Throwable>, Object> exceptionToCode;
    private final Map<Object, Class<? extends Throwable>> codeToException;

    static {
        new ErrorMapping$();
    }

    public ByteBuffer EmptyByteBuffer() {
        return this.EmptyByteBuffer;
    }

    public short UnknownCode() {
        return this.UnknownCode;
    }

    public short NoError() {
        return this.NoError;
    }

    public short OffsetOutOfRangeCode() {
        return this.OffsetOutOfRangeCode;
    }

    public short InvalidMessageCode() {
        return this.InvalidMessageCode;
    }

    public short UnknownTopicOrPartitionCode() {
        return this.UnknownTopicOrPartitionCode;
    }

    public short InvalidFetchSizeCode() {
        return this.InvalidFetchSizeCode;
    }

    public short LeaderNotAvailableCode() {
        return this.LeaderNotAvailableCode;
    }

    public short NotLeaderForPartitionCode() {
        return this.NotLeaderForPartitionCode;
    }

    public short RequestTimedOutCode() {
        return this.RequestTimedOutCode;
    }

    public short BrokerNotAvailableCode() {
        return this.BrokerNotAvailableCode;
    }

    public short ReplicaNotAvailableCode() {
        return this.ReplicaNotAvailableCode;
    }

    public short MessageSizeTooLargeCode() {
        return this.MessageSizeTooLargeCode;
    }

    public short StaleControllerEpochCode() {
        return this.StaleControllerEpochCode;
    }

    public short OffsetMetadataTooLargeCode() {
        return this.OffsetMetadataTooLargeCode;
    }

    public short StaleLeaderEpochCode() {
        return this.StaleLeaderEpochCode;
    }

    private Map<Class<Throwable>, Object> exceptionToCode() {
        return this.exceptionToCode;
    }

    private Map<Object, Class<? extends Throwable>> codeToException() {
        return this.codeToException;
    }

    public short codeFor(Class<Throwable> exception) {
        return BoxesRunTime.unboxToShort(this.exceptionToCode().apply(exception));
    }

    public void maybeThrowException(short code) {
        if (code != 0) {
            throw (Throwable)((Class)this.codeToException().apply(BoxesRunTime.boxToShort(code))).newInstance();
        }
    }

    public Throwable exceptionFor(short code) {
        return (Throwable)((Class)this.codeToException().apply(BoxesRunTime.boxToShort(code))).newInstance();
    }

    private ErrorMapping$() {
        MODULE$ = this;
        this.EmptyByteBuffer = ByteBuffer.allocate(0);
        this.UnknownCode = (short)-1;
        this.NoError = 0;
        this.OffsetOutOfRangeCode = 1;
        this.InvalidMessageCode = (short)2;
        this.UnknownTopicOrPartitionCode = (short)3;
        this.InvalidFetchSizeCode = (short)4;
        this.LeaderNotAvailableCode = (short)5;
        this.NotLeaderForPartitionCode = (short)6;
        this.RequestTimedOutCode = (short)7;
        this.BrokerNotAvailableCode = (short)8;
        this.ReplicaNotAvailableCode = (short)9;
        this.MessageSizeTooLargeCode = (short)10;
        this.StaleControllerEpochCode = (short)11;
        this.OffsetMetadataTooLargeCode = (short)12;
        this.StaleLeaderEpochCode = (short)13;
        this.exceptionToCode = ((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(OffsetOutOfRangeException.class).$minus$greater(BoxesRunTime.boxToShort(this.OffsetOutOfRangeCode())), Predef$.MODULE$.any2ArrowAssoc(InvalidMessageException.class).$minus$greater(BoxesRunTime.boxToShort(this.InvalidMessageCode())), Predef$.MODULE$.any2ArrowAssoc(UnknownTopicOrPartitionException.class).$minus$greater(BoxesRunTime.boxToShort(this.UnknownTopicOrPartitionCode())), Predef$.MODULE$.any2ArrowAssoc(InvalidMessageSizeException.class).$minus$greater(BoxesRunTime.boxToShort(this.InvalidFetchSizeCode())), Predef$.MODULE$.any2ArrowAssoc(NotLeaderForPartitionException.class).$minus$greater(BoxesRunTime.boxToShort(this.NotLeaderForPartitionCode())), Predef$.MODULE$.any2ArrowAssoc(LeaderNotAvailableException.class).$minus$greater(BoxesRunTime.boxToShort(this.LeaderNotAvailableCode())), Predef$.MODULE$.any2ArrowAssoc(RequestTimedOutException.class).$minus$greater(BoxesRunTime.boxToShort(this.RequestTimedOutCode())), Predef$.MODULE$.any2ArrowAssoc(BrokerNotAvailableException.class).$minus$greater(BoxesRunTime.boxToShort(this.BrokerNotAvailableCode())), Predef$.MODULE$.any2ArrowAssoc(ReplicaNotAvailableException.class).$minus$greater(BoxesRunTime.boxToShort(this.ReplicaNotAvailableCode())), Predef$.MODULE$.any2ArrowAssoc(MessageSizeTooLargeException.class).$minus$greater(BoxesRunTime.boxToShort(this.MessageSizeTooLargeCode())), Predef$.MODULE$.any2ArrowAssoc(ControllerMovedException.class).$minus$greater(BoxesRunTime.boxToShort(this.StaleControllerEpochCode())), Predef$.MODULE$.any2ArrowAssoc(OffsetMetadataTooLargeException.class).$minus$greater(BoxesRunTime.boxToShort(this.OffsetMetadataTooLargeCode()))}))).withDefaultValue(BoxesRunTime.boxToShort(this.UnknownCode()));
        this.codeToException = ((MapLike)Predef$.MODULE$.Map().apply(Nil$.MODULE$)).$plus$plus(this.exceptionToCode().iterator().map(new anonfun.1())).withDefaultValue(UnknownException.class);
    }
}

