/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.nio.ByteBuffer;
import kafka.api.ApiUtils$;
import kafka.cluster.Broker;
import kafka.common.BrokerNotAvailableException;
import kafka.common.KafkaException;
import kafka.utils.Json$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class Broker$
implements ScalaObject,
Serializable {
    public static final Broker$ MODULE$;

    static {
        new Broker$();
    }

    public Broker createBroker(int id, String brokerInfoString) {
        Option<Object> option;
        block5: {
            if (brokerInfoString == null) {
                throw new BrokerNotAvailableException(Predef$.MODULE$.augmentString("Broker id %s does not exist").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id)})));
            }
            Broker exceptionResult1 = null;
            try {
                Object a;
                option = Json$.MODULE$.parseFull(brokerInfoString);
                if (!(option instanceof Some)) break block5;
                Some some = (Some)option;
                Object m = a = some.x();
                Map brokerInfo = (Map)m;
                String host = (String)brokerInfo.get("host").get();
                int port = BoxesRunTime.unboxToInt(brokerInfo.get("port").get());
                exceptionResult1 = new Broker(id, host, port);
                return exceptionResult1;
            }
            catch (Throwable throwable) {
                throw new KafkaException(new StringBuilder().append((Object)"Failed to parse the broker info from zookeeper: ").append((Object)brokerInfoString).toString(), throwable);
            }
        }
        None$ none$ = None$.MODULE$;
        Option<Object> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new BrokerNotAvailableException(Predef$.MODULE$.augmentString("Broker id %d does not exist").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id)})));
        }
        throw new MatchError(option);
    }

    public Broker readFrom(ByteBuffer buffer) {
        int id = buffer.getInt();
        String host = ApiUtils$.MODULE$.readShortString(buffer);
        int port = buffer.getInt();
        return new Broker(id, host, port);
    }

    public Option unapply(Broker x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple3<Integer, String, Integer>>(new Tuple3<Integer, String, Integer>(BoxesRunTime.boxToInteger(x$0.id()), x$0.host(), BoxesRunTime.boxToInteger(x$0.port())));
    }

    public Broker apply(int id, String host, int port) {
        return new Broker(id, host, port);
    }

    public Object readResolve() {
        return MODULE$;
    }

    private Broker$() {
        MODULE$ = this;
    }
}

