/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.cluster.Broker;
import kafka.consumer.Whitelist;
import kafka.log.LogConfig$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$String$;
import scala.reflect.Manifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TopicCommand$
implements ScalaObject {
    public static final TopicCommand$ MODULE$;

    static {
        new TopicCommand$();
    }

    public void main(String[] args) {
        TopicCommand.TopicCommandOptions opts$1 = new TopicCommand.TopicCommandOptions(args);
        int actions = ((TraversableOnce)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts$1.createOpt(), opts$1.listOpt(), opts$1.alterOpt(), opts$1.describeOpt()}))).count(new Serializable(opts$1){
            public static final long serialVersionUID;
            private final TopicCommand.TopicCommandOptions opts$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(OptionSpec<?> optionSpec) {
                return this.opts$1.options().has(optionSpec);
            }
            {
                this.opts$1 = topicCommandOptions;
            }
        });
        if (actions != 1) {
            System.err.println("Command must include exactly one action: --list, --describe, --create or --alter");
            opts$1.parser().printHelpOn(System.err);
            System.exit(1);
        }
        opts$1.checkArgs();
        ZkClient zkClient = new ZkClient(opts$1.options().valueOf(opts$1.zkConnectOpt()), 30000, 30000, ZKStringSerializer$.MODULE$);
        try {
            if (opts$1.options().has(opts$1.createOpt())) {
                this.createTopic(zkClient, opts$1);
            } else if (opts$1.options().has(opts$1.alterOpt())) {
                this.alterTopic(zkClient, opts$1);
            } else if (opts$1.options().has(opts$1.listOpt())) {
                this.listTopics(zkClient, opts$1);
            } else if (opts$1.options().has(opts$1.describeOpt())) {
                this.describeTopic(zkClient, opts$1);
            }
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println(new StringBuilder().append((Object)"Error while executing topic command ").append((Object)throwable.getMessage()).toString());
            Predef$.MODULE$.println(Utils$.MODULE$.stackTrace(throwable));
        }
        zkClient.close();
        return;
        {
            finally {
                zkClient.close();
            }
        }
    }

    private Seq<String> getTopics(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq seq2;
        Seq allTopics = (Seq)ZkUtils$.MODULE$.getAllTopics(zkClient).sorted(Ordering$String$.MODULE$);
        if (opts.options().has(opts.topicOpt())) {
            String topicsSpec = opts.options().valueOf(opts.topicOpt());
            Whitelist topicsFilter$1 = new Whitelist(topicsSpec);
            seq2 = (Seq)allTopics.filter(new Serializable(topicsFilter$1){
                public static final long serialVersionUID;
                private final Whitelist topicsFilter$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(String string2) {
                    return this.topicsFilter$1.isTopicAllowed(string2);
                }
                {
                    this.topicsFilter$1 = whitelist;
                }
            });
        } else {
            seq2 = allTopics;
        }
        return seq2;
    }

    public void createTopic(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        String topic = opts.options().valueOf(opts.topicOpt());
        Properties configs = this.parseTopicConfigsToBeAdded(opts);
        if (opts.options().has(opts.replicaAssignmentOpt())) {
            Map<Object, Seq<Object>> assignment = this.parseReplicaAssignment(opts.options().valueOf(opts.replicaAssignmentOpt()));
            AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(zkClient, topic, assignment, configs, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        } else {
            CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.partitionsOpt(), opts.replicationFactorOpt()}));
            int partitions = opts.options().valueOf(opts.partitionsOpt());
            int replicas = opts.options().valueOf(opts.replicationFactorOpt());
            AdminUtils$.MODULE$.createTopic(zkClient, topic, partitions, replicas, configs);
        }
        Predef$.MODULE$.println(Predef$.MODULE$.augmentString("Created topic \"%s\".").format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
    }

    public void alterTopic(ZkClient zkClient$1, TopicCommand.TopicCommandOptions opts$2) {
        Seq<String> topics = this.getTopics(zkClient$1, opts$2);
        topics.foreach(new Serializable(zkClient$1, opts$2){
            public static final long serialVersionUID;
            private final ZkClient zkClient$1;
            private final TopicCommand.TopicCommandOptions opts$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String topic) {
                if (this.opts$2.options().has(this.opts$2.configOpt()) || this.opts$2.options().has(this.opts$2.deleteConfigOpt())) {
                    Properties configsToBeAdded = TopicCommand$.MODULE$.parseTopicConfigsToBeAdded(this.opts$2);
                    Seq<String> configsToBeDeleted = TopicCommand$.MODULE$.parseTopicConfigsToBeDeleted(this.opts$2);
                    Properties configs$1 = AdminUtils$.MODULE$.fetchTopicConfig(this.zkClient$1, topic);
                    configs$1.putAll((java.util.Map<?, ?>)configsToBeAdded);
                    configsToBeDeleted.foreach(new Serializable(this, configs$1){
                        public static final long serialVersionUID;
                        private final Properties configs$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Object apply(String config) {
                            return this.configs$1.remove(config);
                        }
                        {
                            this.configs$1 = properties;
                        }
                    });
                    AdminUtils$.MODULE$.changeTopicConfig(this.zkClient$1, topic, configs$1);
                    Predef$.MODULE$.println(Predef$.MODULE$.augmentString("Updated config for topic \"%s\".").format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
                }
                if (this.opts$2.options().has(this.opts$2.partitionsOpt())) {
                    Predef$.MODULE$.println("WARNING: If partitions are increased for a topic that has a key, the partition logic or ordering of the messages will be affected");
                    int nPartitions = this.opts$2.options().valueOf(this.opts$2.partitionsOpt());
                    String replicaAssignmentStr = this.opts$2.options().valueOf(this.opts$2.replicaAssignmentOpt());
                    AdminUtils$.MODULE$.addPartitions(this.zkClient$1, topic, nPartitions, replicaAssignmentStr);
                    Predef$.MODULE$.println("Adding partitions succeeded!");
                }
            }
            {
                this.zkClient$1 = zkClient;
                this.opts$2 = topicCommandOptions;
            }
        });
    }

    public void listTopics(ZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        topics.foreach(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String topic) {
                Predef$.MODULE$.println(topic);
            }
        });
    }

    public void describeTopic(ZkClient zkClient$2, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient$2, opts);
        boolean reportUnderReplicatedPartitions$1 = opts.options().has(opts.reportUnderReplicatedPartitionsOpt());
        boolean reportUnavailablePartitions$1 = opts.options().has(opts.reportUnavailablePartitionsOpt());
        boolean reportOverriddenConfigs$1 = opts.options().has(opts.topicsWithOverridesOpt());
        Set liveBrokers$1 = ((TraversableOnce)ZkUtils$.MODULE$.getAllBrokersInCluster(zkClient$2).map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(Broker broker) {
                return broker.id();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        topics.foreach(new Serializable(zkClient$2, reportUnderReplicatedPartitions$1, reportUnavailablePartitions$1, reportOverriddenConfigs$1, liveBrokers$1){
            public static final long serialVersionUID;
            public final ZkClient zkClient$2;
            public final boolean reportUnderReplicatedPartitions$1;
            public final boolean reportUnavailablePartitions$1;
            private final boolean reportOverriddenConfigs$1;
            public final Set liveBrokers$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String topic$1) {
                Option<B> option;
                block9: {
                    block8: {
                        block7: {
                            Map map2;
                            option = ZkUtils$.MODULE$.getPartitionAssignmentForTopics(this.zkClient$2, (Seq<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))).get(topic$1);
                            if (!(option instanceof Some)) break block7;
                            Some some = (Some)option;
                            Map topicPartitionAssignment = map2 = (Map)some.x();
                            boolean describeConfigs = !this.reportUnavailablePartitions$1 && !this.reportUnderReplicatedPartitions$1;
                            boolean describePartitions = !this.reportOverriddenConfigs$1;
                            List sortedPartitions = (List)topicPartitionAssignment.toList().sortWith(new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final boolean apply(Tuple2<Object, Seq<Object>> m1, Tuple2<Object, Seq<Object>> m2) {
                                    return m1._1$mcI$sp() < m2._1$mcI$sp();
                                }
                            });
                            if (describeConfigs) {
                                Properties configs = AdminUtils$.MODULE$.fetchTopicConfig(this.zkClient$2, topic$1);
                                if (!this.reportOverriddenConfigs$1 || configs.size() != 0) {
                                    int numPartitions = topicPartitionAssignment.size();
                                    int replicationFactor = ((SeqLike)((Tuple2)topicPartitionAssignment.head())._2()).size();
                                    Predef$.MODULE$.println(Predef$.MODULE$.augmentString("Topic:%s\tPartitionCount:%d\tReplicationFactor:%d\tConfigs:%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{topic$1, BoxesRunTime.boxToInteger(numPartitions), BoxesRunTime.boxToInteger(replicationFactor), ((TraversableOnce)JavaConversions$.MODULE$.propertiesAsScalaMap(configs).map((Function1<String, String>)((Object)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply(Tuple2<String, String> kv) {
                                            return new StringBuilder().append((Object)kv._1()).append((Object)"=").append((Object)kv._2()).toString();
                                        }
                                    }), Iterable$.MODULE$.canBuildFrom())).mkString(",")})));
                                }
                            }
                            if (describePartitions) {
                                ((LinearSeqOptimized)sortedPartitions.filter(new Serializable(this){
                                    public static final long serialVersionUID;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final boolean apply(Tuple2<Object, Seq<Object>> tuple2) {
                                        Tuple2<Object, Seq<Object>> tuple22 = tuple2;
                                        return tuple22 != null;
                                    }
                                })).foreach(new Serializable(this, topic$1){
                                    public static final long serialVersionUID;
                                    private final anonfun.describeTopic.1 $outer;
                                    private final String topic$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final void apply(Tuple2<Object, Seq<Object>> tuple2) {
                                        Tuple2<Object, Seq<Object>> tuple22 = tuple2;
                                        if (tuple22 != null) {
                                            int n = BoxesRunTime.unboxToInt(tuple22._1());
                                            Seq<Object> seq2 = tuple22._2();
                                            int partitionId = n;
                                            Seq<Object> assignedReplicas = seq2;
                                            Seq<Object> inSyncReplicas = ZkUtils$.MODULE$.getInSyncReplicasForPartition(this.$outer.zkClient$2, this.topic$1, partitionId);
                                            Option<Object> leader = ZkUtils$.MODULE$.getLeaderForPartition(this.$outer.zkClient$2, this.topic$1, partitionId);
                                            if (!this.$outer.reportUnderReplicatedPartitions$1 && !this.$outer.reportUnavailablePartitions$1 || this.$outer.reportUnderReplicatedPartitions$1 && inSyncReplicas.size() < assignedReplicas.size() || this.$outer.reportUnavailablePartitions$1 && (!leader.isDefined() || !this.$outer.liveBrokers$1.contains(leader.get()))) {
                                                Predef$.MODULE$.print(new StringBuilder().append((Object)"\tTopic: ").append((Object)this.topic$1).toString());
                                                Predef$.MODULE$.print(new StringBuilder().append((Object)"\tPartition: ").append(BoxesRunTime.boxToInteger(partitionId)).toString());
                                                Predef$.MODULE$.print(new StringBuilder().append((Object)"\tLeader: ").append(leader.isDefined() ? leader.get() : "none").toString());
                                                Predef$.MODULE$.print(new StringBuilder().append((Object)"\tReplicas: ").append((Object)assignedReplicas.mkString(",")).toString());
                                                Predef$.MODULE$.println(new StringBuilder().append((Object)"\tIsr: ").append((Object)inSyncReplicas.mkString(",")).toString());
                                            }
                                            return;
                                        }
                                        throw new MatchError(tuple22);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.topic$1 = string2;
                                    }
                                });
                            }
                            break block8;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<B> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                        Predef$.MODULE$.println(new StringBuilder().append((Object)"Topic ").append((Object)topic$1).append((Object)" doesn't exist!").toString());
                    }
                    return;
                }
                throw new MatchError(option);
            }
            {
                this.zkClient$2 = zkClient;
                this.reportUnderReplicatedPartitions$1 = bl;
                this.reportUnavailablePartitions$1 = bl2;
                this.reportOverriddenConfigs$1 = bl3;
                this.liveBrokers$1 = set;
            }
        });
    }

    public String formatBroker(Broker broker) {
        return new StringBuilder().append(broker.id()).append((Object)" (").append((Object)broker.host()).append((Object)":").append(BoxesRunTime.boxToInteger(broker.port())).append((Object)")").toString();
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseTopicConfigsToBeAdded(TopicCommand.TopicCommandOptions opts) {
        void var3_3;
        Buffer configsToBeAdded = JavaConversions$.MODULE$.asScalaBuffer(opts.options().valuesOf(opts.configOpt())).map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String[] apply(String string2) {
                return string2.split("\\s*=\\s*");
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(configsToBeAdded.forall(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String[] config) {
                return config.length == 2;
            }
        }), (Function0<Object>)((Object)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Invalid topic config: all configs to be added must be in the format \"key=val\".";
            }
        }));
        Properties props$1 = new Properties();
        configsToBeAdded.foreach(new Serializable(props$1){
            public static final long serialVersionUID;
            private final Properties props$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(String[] pair2) {
                return this.props$1.setProperty(pair2[0].trim(), pair2[1].trim());
            }
            {
                this.props$1 = properties;
            }
        });
        LogConfig$.MODULE$.validate(props$1);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseTopicConfigsToBeDeleted(TopicCommand.TopicCommandOptions opts) {
        Seq seq2;
        if (opts.options().has(opts.deleteConfigOpt())) {
            void var2_2;
            Buffer configsToBeDeleted = JavaConversions$.MODULE$.asScalaBuffer(opts.options().valuesOf(opts.deleteConfigOpt())).map(new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(String string2) {
                    return string2.trim();
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted$1 = new Properties();
            configsToBeDeleted.foreach(new Serializable(propsToBeDeleted$1){
                public static final long serialVersionUID;
                private final Properties propsToBeDeleted$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply(String string2) {
                    return this.propsToBeDeleted$1.setProperty(string2, "");
                }
                {
                    this.propsToBeDeleted$1 = properties;
                }
            });
            LogConfig$.MODULE$.validateNames(propsToBeDeleted$1);
            seq2 = var2_2;
        } else {
            seq2 = (Seq)Seq$.MODULE$.empty();
        }
        return seq2;
    }

    public Map<Object, List<Object>> parseReplicaAssignment(String replicaAssignmentList) {
        String[] partitionList$1 = replicaAssignmentList.split(",");
        HashMap ret$1 = new HashMap();
        Predef$.MODULE$.intWrapper(0).until(Predef$.MODULE$.refArrayOps((Object[])partitionList$1).size()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(partitionList$1, ret$1){
            public static final long serialVersionUID;
            private final String[] partitionList$1;
            private final HashMap ret$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                int[] brokerList = (int[])Predef$.MODULE$.refArrayOps((Object[])this.partitionList$1[v1].split(":")).map(new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final int apply(String s) {
                        return Predef$.MODULE$.augmentString(s.trim()).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom(Manifest$.MODULE$.Int()));
                this.ret$1.put(BoxesRunTime.boxToInteger(v1), Predef$.MODULE$.intArrayOps(brokerList).toList());
                if (((SeqLike)this.ret$1.apply(BoxesRunTime.boxToInteger(v1))).size() != ((SeqLike)this.ret$1.apply(BoxesRunTime.boxToInteger(0))).size()) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"Partition ").append(BoxesRunTime.boxToInteger(v1)).append((Object)" has different replication factor: ").append(brokerList).toString());
                }
            }
            {
                this.partitionList$1 = stringArray;
                this.ret$1 = hashMap;
            }
        }));
        return ret$1.toMap(Predef$.MODULE$.conforms());
    }

    private TopicCommand$() {
        MODULE$ = this;
    }
}

