/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;

public final class DeleteTopicCommand$
implements ScalaObject {
    public static final DeleteTopicCommand$ MODULE$;

    static {
        new DeleteTopicCommand$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec<String> topicOpt = parser$1.accepts("topic", "REQUIRED: The topic to be deleted.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> zkConnectOpt = parser$1.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        OptionSet options$1 = parser$1.parse(args);
        List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{topicOpt, zkConnectOpt})).foreach(new Serializable(parser$1, options$1){
            public static final long serialVersionUID;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ArgumentAcceptingOptionSpec<String> arg) {
                if (!this.options$1.has(arg)) {
                    System.err.println(new StringBuilder().append((Object)"Missing required argument \"").append(arg).append((Object)"\"").toString());
                    this.parser$1.printHelpOn(System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = optionParser;
                this.options$1 = optionSet;
            }
        });
        String topic = options$1.valueOf(topicOpt);
        String zkConnect = options$1.valueOf(zkConnectOpt);
        ZkClient zkClient = null;
        try {
            zkClient = new ZkClient(zkConnect, 30000, 30000, ZKStringSerializer$.MODULE$);
            zkClient.deleteRecursive(ZkUtils$.MODULE$.getTopicPath(topic));
            Predef$.MODULE$.println("deletion succeeded!");
            if (zkClient == null) return;
        }
        catch (Throwable throwable) {
            try {
                Predef$.MODULE$.println(new StringBuilder().append((Object)"delection failed because of ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println(Utils$.MODULE$.stackTrace(throwable));
            }
            finally {
                if (zkClient == null) return;
                zkClient.close();
            }
        }
        zkClient.close();
    }

    private DeleteTopicCommand$() {
        MODULE$ = this;
    }
}

