/*
 * Decompiled with CFR 0.152.
 */
package jersey.repackaged.com.google.common.math;

import javax.annotation.Nullable;

final class MathPreconditions {
    static long checkPositive(@Nullable String role, long x2) {
        if (x2 <= 0L) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be > 0");
        }
        return x2;
    }

    static int checkNonNegative(@Nullable String role, int x2) {
        if (x2 < 0) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be >= 0");
        }
        return x2;
    }

    static long checkNonNegative(@Nullable String role, long x2) {
        if (x2 < 0L) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be >= 0");
        }
        return x2;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkNoOverflow(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("overflow");
        }
    }
}

