/*
 * Decompiled with CFR 0.152.
 */
package jersey.repackaged.com.google.common.hash;

import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import jersey.repackaged.com.google.common.base.Supplier;
import jersey.repackaged.com.google.common.hash.ChecksumHashFunction;
import jersey.repackaged.com.google.common.hash.HashFunction;
import jersey.repackaged.com.google.common.hash.MessageDigestHashFunction;
import jersey.repackaged.com.google.common.hash.Murmur3_128HashFunction;
import jersey.repackaged.com.google.common.hash.Murmur3_32HashFunction;

public final class Hashing {
    private static final int GOOD_FAST_HASH_SEED = (int)System.currentTimeMillis();
    private static final HashFunction GOOD_FAST_HASH_FUNCTION_32 = Hashing.murmur3_32(GOOD_FAST_HASH_SEED);
    private static final HashFunction GOOD_FAST_HASH_FUNCTION_128 = Hashing.murmur3_128(GOOD_FAST_HASH_SEED);
    private static final HashFunction MURMUR3_32 = new Murmur3_32HashFunction(0);
    private static final HashFunction MURMUR3_128 = new Murmur3_128HashFunction(0);
    private static final HashFunction MD5 = new MessageDigestHashFunction("MD5", "Hashing.md5()");
    private static final HashFunction SHA_1 = new MessageDigestHashFunction("SHA-1", "Hashing.sha1()");
    private static final HashFunction SHA_256 = new MessageDigestHashFunction("SHA-256", "Hashing.sha256()");
    private static final HashFunction SHA_512 = new MessageDigestHashFunction("SHA-512", "Hashing.sha512()");
    private static final HashFunction CRC_32 = Hashing.checksumHashFunction(ChecksumType.CRC_32, "Hashing.crc32()");
    private static final HashFunction ADLER_32 = Hashing.checksumHashFunction(ChecksumType.ADLER_32, "Hashing.adler32()");

    public static HashFunction murmur3_32(int seed) {
        return new Murmur3_32HashFunction(seed);
    }

    public static HashFunction murmur3_32() {
        return MURMUR3_32;
    }

    public static HashFunction murmur3_128(int seed) {
        return new Murmur3_128HashFunction(seed);
    }

    private static HashFunction checksumHashFunction(ChecksumType type, String toString2) {
        return new ChecksumHashFunction(type, type.bits, toString2);
    }

    static abstract class ChecksumType
    extends Enum<ChecksumType>
    implements Supplier<Checksum> {
        public static final /* enum */ ChecksumType CRC_32 = new ChecksumType(32){

            @Override
            public Checksum get() {
                return new CRC32();
            }
        };
        public static final /* enum */ ChecksumType ADLER_32 = new ChecksumType(32){

            @Override
            public Checksum get() {
                return new Adler32();
            }
        };
        private final int bits;
        private static final /* synthetic */ ChecksumType[] $VALUES;

        private ChecksumType(int bits2) {
            this.bits = bits2;
        }

        @Override
        public abstract Checksum get();

        static {
            $VALUES = new ChecksumType[]{CRC_32, ADLER_32};
        }
    }
}

