/*
 * Decompiled with CFR 0.152.
 */
package jersey.repackaged.com.google.common.hash;

import java.io.Serializable;
import java.util.zip.Checksum;
import jersey.repackaged.com.google.common.base.Preconditions;
import jersey.repackaged.com.google.common.base.Supplier;
import jersey.repackaged.com.google.common.hash.AbstractByteHasher;
import jersey.repackaged.com.google.common.hash.AbstractStreamingHashFunction;
import jersey.repackaged.com.google.common.hash.HashCode;
import jersey.repackaged.com.google.common.hash.HashCodes;
import jersey.repackaged.com.google.common.hash.Hasher;

final class ChecksumHashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final Supplier<? extends Checksum> checksumSupplier;
    private final int bits;
    private final String toString;

    ChecksumHashFunction(Supplier<? extends Checksum> checksumSupplier, int bits2, String toString2) {
        this.checksumSupplier = Preconditions.checkNotNull(checksumSupplier);
        Preconditions.checkArgument(bits2 == 32 || bits2 == 64, "bits (%s) must be either 32 or 64", bits2);
        this.bits = bits2;
        this.toString = Preconditions.checkNotNull(toString2);
    }

    @Override
    public Hasher newHasher() {
        return new ChecksumHasher(this.checksumSupplier.get());
    }

    public String toString() {
        return this.toString;
    }

    private final class ChecksumHasher
    extends AbstractByteHasher {
        private final Checksum checksum;

        private ChecksumHasher(Checksum checksum) {
            this.checksum = Preconditions.checkNotNull(checksum);
        }

        @Override
        protected void update(byte b) {
            this.checksum.update(b);
        }

        @Override
        protected void update(byte[] bytes, int off, int len) {
            this.checksum.update(bytes, off, len);
        }

        @Override
        public HashCode hash() {
            long value2 = this.checksum.getValue();
            if (ChecksumHashFunction.this.bits == 32) {
                return HashCodes.fromInt((int)value2);
            }
            return HashCodes.fromLong(value2);
        }
    }
}

