/*
 * Decompiled with CFR 0.152.
 */
package jersey.repackaged.com.google.common.collect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Map;
import jersey.repackaged.com.google.common.collect.Multimap;

final class Serialization {
    static int readCount(ObjectInputStream stream) throws IOException {
        return stream.readInt();
    }

    static <K, V> void writeMultimap(Multimap<K, V> multimap, ObjectOutputStream stream) throws IOException {
        stream.writeInt(multimap.asMap().size());
        for (Map.Entry<K, Collection<V>> entry2 : multimap.asMap().entrySet()) {
            stream.writeObject(entry2.getKey());
            stream.writeInt(entry2.getValue().size());
            for (V value2 : entry2.getValue()) {
                stream.writeObject(value2);
            }
        }
    }

    static <K, V> void populateMultimap(Multimap<K, V> multimap, ObjectInputStream stream, int distinctKeys) throws IOException, ClassNotFoundException {
        for (int i = 0; i < distinctKeys; ++i) {
            Object key = stream.readObject();
            Collection<V> values2 = multimap.get(key);
            int valueCount = stream.readInt();
            for (int j = 0; j < valueCount; ++j) {
                Object value2 = stream.readObject();
                values2.add(value2);
            }
        }
    }
}

