/*
 * Decompiled with CFR 0.152.
 */
package jersey.repackaged.com.google.common.collect;

import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import jersey.repackaged.com.google.common.collect.ImmutableCollection;
import jersey.repackaged.com.google.common.collect.ImmutableSet;
import jersey.repackaged.com.google.common.collect.Multiset;
import jersey.repackaged.com.google.common.collect.ObjectArrays;
import jersey.repackaged.com.google.common.collect.Sets;
import jersey.repackaged.com.google.common.collect.UnmodifiableIterator;

public abstract class ImmutableMultiset<E>
extends ImmutableCollection<E>
implements Multiset<E> {
    private transient ImmutableSet<Multiset.Entry<E>> entrySet;

    ImmutableMultiset() {
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        final Iterator entryIterator = ((ImmutableSet)this.entrySet()).iterator();
        return new UnmodifiableIterator<E>(){
            int remaining;
            E element;

            @Override
            public boolean hasNext() {
                return this.remaining > 0 || entryIterator.hasNext();
            }

            @Override
            public E next() {
                if (this.remaining <= 0) {
                    Multiset.Entry entry2 = (Multiset.Entry)entryIterator.next();
                    this.element = entry2.getElement();
                    this.remaining = entry2.getCount();
                }
                --this.remaining;
                return this.element;
            }
        };
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.count(object) > 0;
    }

    @Override
    public boolean containsAll(Collection<?> targets) {
        return this.elementSet().containsAll(targets);
    }

    @Override
    @Deprecated
    public final int add(E element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final int remove(Object element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final int setCount(E element, int count2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean setCount(E element, int oldCount, int newCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Multiset) {
            Multiset that = (Multiset)object;
            if (this.size() != that.size()) {
                return false;
            }
            for (Multiset.Entry entry2 : that.entrySet()) {
                if (this.count(entry2.getElement()) == entry2.getCount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    @Override
    public String toString() {
        return ((ImmutableCollection)((Object)this.entrySet())).toString();
    }

    @Override
    public ImmutableSet<Multiset.Entry<E>> entrySet() {
        ImmutableSet<Multiset.Entry<Multiset.Entry<E>>> es = this.entrySet;
        return es == null ? (this.entrySet = this.createEntrySet()) : es;
    }

    abstract ImmutableSet<Multiset.Entry<E>> createEntrySet();

    abstract class EntrySet
    extends ImmutableSet<Multiset.Entry<E>> {
        EntrySet() {
        }

        @Override
        boolean isPartialView() {
            return ImmutableMultiset.this.isPartialView();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Multiset.Entry) {
                Multiset.Entry entry2 = (Multiset.Entry)o;
                if (entry2.getCount() <= 0) {
                    return false;
                }
                int count2 = ImmutableMultiset.this.count(entry2.getElement());
                return count2 == entry2.getCount();
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            Object[] newArray = new Object[this.size()];
            return this.toArray(newArray);
        }

        @Override
        public <T> T[] toArray(T[] other) {
            int size2 = this.size();
            if (other.length < size2) {
                other = ObjectArrays.newArray(other, size2);
            } else if (other.length > size2) {
                other[size2] = null;
            }
            T[] otherAsObjectArray = other;
            int index = 0;
            for (Multiset.Entry element : this) {
                otherAsObjectArray[index++] = element;
            }
            return other;
        }

        @Override
        public int hashCode() {
            return ImmutableMultiset.this.hashCode();
        }
    }
}

