/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarasm.asm.commons;

import groovyjarjarasm.asm.AnnotationVisitor;
import groovyjarjarasm.asm.Handle;
import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.commons.LocalVariablesSorter;
import groovyjarjarasm.asm.commons.Remapper;
import groovyjarjarasm.asm.commons.RemappingAnnotationAdapter;

public class RemappingMethodAdapter
extends LocalVariablesSorter {
    protected final Remapper remapper;

    public RemappingMethodAdapter(int n, String string2, MethodVisitor methodVisitor, Remapper remapper) {
        this(262144, n, string2, methodVisitor, remapper);
    }

    protected RemappingMethodAdapter(int n, int n2, String string2, MethodVisitor methodVisitor, Remapper remapper) {
        super(n, n2, string2, methodVisitor);
        this.remapper = remapper;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationVisitor annotationVisitor = this.mv.visitAnnotationDefault();
        return annotationVisitor == null ? annotationVisitor : new RemappingAnnotationAdapter(annotationVisitor, this.remapper);
    }

    public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
        AnnotationVisitor annotationVisitor = this.mv.visitAnnotation(this.remapper.mapDesc(string2), bl);
        return annotationVisitor == null ? annotationVisitor : new RemappingAnnotationAdapter(annotationVisitor, this.remapper);
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string2, boolean bl) {
        AnnotationVisitor annotationVisitor = this.mv.visitParameterAnnotation(n, this.remapper.mapDesc(string2), bl);
        return annotationVisitor == null ? annotationVisitor : new RemappingAnnotationAdapter(annotationVisitor, this.remapper);
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        super.visitFrame(n, n2, this.remapEntries(n2, objectArray), n3, this.remapEntries(n3, objectArray2));
    }

    private Object[] remapEntries(int n, Object[] objectArray) {
        for (int i = 0; i < n; ++i) {
            if (!(objectArray[i] instanceof String)) continue;
            Object[] objectArray2 = new Object[n];
            if (i > 0) {
                System.arraycopy(objectArray, 0, objectArray2, 0, i);
            }
            do {
                Object object = objectArray[i];
                Object object2 = objectArray2[i++] = object instanceof String ? this.remapper.mapType((String)object) : object;
            } while (i < n);
            return objectArray2;
        }
        return objectArray;
    }

    public void visitFieldInsn(int n, String string2, String string3, String string4) {
        super.visitFieldInsn(n, this.remapper.mapType(string2), this.remapper.mapFieldName(string2, string3, string4), this.remapper.mapDesc(string4));
    }

    public void visitMethodInsn(int n, String string2, String string3, String string4) {
        super.visitMethodInsn(n, this.remapper.mapType(string2), this.remapper.mapMethodName(string2, string3, string4), this.remapper.mapMethodDesc(string4));
    }

    public void visitInvokeDynamicInsn(String string2, String string3, Handle handle2, Object ... objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.remapper.mapValue(objectArray[i]);
        }
        super.visitInvokeDynamicInsn(this.remapper.mapInvokeDynamicMethodName(string2, string3), this.remapper.mapMethodDesc(string3), (Handle)this.remapper.mapValue(handle2), objectArray);
    }

    public void visitTypeInsn(int n, String string2) {
        super.visitTypeInsn(n, this.remapper.mapType(string2));
    }

    public void visitLdcInsn(Object object) {
        super.visitLdcInsn(this.remapper.mapValue(object));
    }

    public void visitMultiANewArrayInsn(String string2, int n) {
        super.visitMultiANewArrayInsn(this.remapper.mapDesc(string2), n);
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string2) {
        super.visitTryCatchBlock(label, label2, label3, string2 == null ? null : this.remapper.mapType(string2));
    }

    public void visitLocalVariable(String string2, String string3, String string4, Label label, Label label2, int n) {
        super.visitLocalVariable(string2, this.remapper.mapDesc(string3), this.remapper.mapSignature(string4, true), label, label2, n);
    }
}

