/*
 * Decompiled with CFR 0.152.
 */
package groovy.xml;

import groovy.util.BuilderSupport;
import groovy.xml.FactorySupport;
import groovy.xml.QName;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMBuilder
extends BuilderSupport {
    Document document;
    DocumentBuilder documentBuilder;

    public static DOMBuilder newInstance() throws ParserConfigurationException {
        return DOMBuilder.newInstance(false, true);
    }

    public static DOMBuilder newInstance(boolean validating, boolean namespaceAware) throws ParserConfigurationException {
        DocumentBuilderFactory factory = FactorySupport.createDocumentBuilderFactory();
        factory.setNamespaceAware(namespaceAware);
        factory.setValidating(validating);
        return new DOMBuilder(factory.newDocumentBuilder());
    }

    public static Document parse(Reader reader) throws SAXException, IOException, ParserConfigurationException {
        return DOMBuilder.parse(reader, false, true);
    }

    public static Document parse(Reader reader, boolean validating, boolean namespaceAware) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = FactorySupport.createDocumentBuilderFactory();
        factory.setNamespaceAware(namespaceAware);
        factory.setValidating(validating);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        return documentBuilder.parse(new InputSource(reader));
    }

    public Document parseText(String text2) throws SAXException, IOException, ParserConfigurationException {
        return DOMBuilder.parse(new StringReader(text2));
    }

    public DOMBuilder(Document document2) {
        this.document = document2;
    }

    public DOMBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    @Override
    protected void setParent(Object parent, Object child) {
        Node current = (Node)parent;
        Node node = (Node)child;
        current.appendChild(node);
    }

    @Override
    protected Object createNode(Object name) {
        if (this.document == null) {
            this.document = this.createDocument();
        }
        if (name instanceof QName) {
            QName qname = (QName)name;
            return this.document.createElementNS(qname.getNamespaceURI(), qname.getQualifiedName());
        }
        return this.document.createElement(name.toString());
    }

    protected Document createDocument() {
        if (this.documentBuilder == null) {
            throw new IllegalArgumentException("No Document or DOMImplementation available so cannot create Document");
        }
        return this.documentBuilder.newDocument();
    }

    @Override
    protected Object createNode(Object name, Object value2) {
        Element element = (Element)this.createNode(name);
        element.appendChild(this.document.createTextNode(value2.toString()));
        return element;
    }

    @Override
    protected Object createNode(Object name, Map attributes, Object value2) {
        Element element = (Element)this.createNode(name, attributes);
        element.appendChild(this.document.createTextNode(value2.toString()));
        return element;
    }

    @Override
    protected Object createNode(Object name, Map attributes) {
        Element element = (Element)this.createNode(name);
        for (Map.Entry entry2 : attributes.entrySet()) {
            String attrName = entry2.getKey().toString();
            Object value2 = entry2.getValue();
            if ("xmlns".equals(attrName)) {
                if (value2 instanceof Map) {
                    this.appendNamespaceAttributes(element, (Map)value2);
                    continue;
                }
                if (value2 instanceof String) {
                    this.setStringNS(element, "", value2);
                    continue;
                }
                throw new IllegalArgumentException("The value of the xmlns attribute must be a Map of QNames to String URIs");
            }
            if (attrName.startsWith("xmlns:") && value2 instanceof String) {
                this.setStringNS(element, attrName.substring(6), value2);
                continue;
            }
            String valueText = value2 != null ? value2.toString() : "";
            element.setAttribute(attrName, valueText);
        }
        return element;
    }

    protected void appendNamespaceAttributes(Element element, Map<Object, Object> attributes) {
        for (Map.Entry<Object, Object> entry2 : attributes.entrySet()) {
            Object key = entry2.getKey();
            Object value2 = entry2.getValue();
            if (value2 == null) {
                throw new IllegalArgumentException("The value of key: " + key + " cannot be null");
            }
            if (key instanceof String) {
                this.setStringNS(element, key, value2);
                continue;
            }
            if (key instanceof QName) {
                QName qname = (QName)key;
                element.setAttributeNS(qname.getNamespaceURI(), qname.getQualifiedName(), value2.toString());
                continue;
            }
            throw new IllegalArgumentException("The key: " + key + " should be an instanceof of " + QName.class);
        }
    }

    private void setStringNS(Element element, Object key, Object value2) {
        String prefix = (String)key;
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "".equals(prefix) ? "xmlns" : "xmlns:" + prefix, value2.toString());
    }
}

