/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.util.Node;
import groovy.xml.FactorySupport;
import groovy.xml.QName;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XmlParser
implements ContentHandler {
    private StringBuffer bodyText = new StringBuffer();
    private List<Node> stack = new ArrayList<Node>();
    private Locator locator;
    private XMLReader reader;
    private Node parent;
    private boolean trimWhitespace = true;
    private boolean namespaceAware;

    public XmlParser() throws ParserConfigurationException, SAXException {
        this(false, true);
    }

    public XmlParser(boolean validating, boolean namespaceAware) throws ParserConfigurationException, SAXException {
        this(validating, namespaceAware, false);
    }

    public XmlParser(boolean validating, boolean namespaceAware, boolean allowDocTypeDeclaration) throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = FactorySupport.createSaxParserFactory();
        factory.setNamespaceAware(namespaceAware);
        this.namespaceAware = namespaceAware;
        factory.setValidating(validating);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", !allowDocTypeDeclaration);
        this.reader = factory.newSAXParser().getXMLReader();
    }

    public XmlParser(XMLReader reader) {
        this.reader = reader;
    }

    public XmlParser(SAXParser parser) throws SAXException {
        this.reader = parser.getXMLReader();
    }

    public boolean isTrimWhitespace() {
        return this.trimWhitespace;
    }

    public void setTrimWhitespace(boolean trimWhitespace) {
        this.trimWhitespace = trimWhitespace;
    }

    public Node parse(File file) throws IOException, SAXException {
        InputSource input2 = new InputSource(new FileInputStream(file));
        input2.setSystemId("file://" + file.getAbsolutePath());
        this.getXMLReader().parse(input2);
        return this.parent;
    }

    public Node parse(InputSource input2) throws IOException, SAXException {
        this.getXMLReader().parse(input2);
        return this.parent;
    }

    public Node parse(InputStream input2) throws IOException, SAXException {
        InputSource is = new InputSource(input2);
        this.getXMLReader().parse(is);
        return this.parent;
    }

    public Node parse(Reader in) throws IOException, SAXException {
        InputSource is = new InputSource(in);
        this.getXMLReader().parse(is);
        return this.parent;
    }

    public Node parse(String uri) throws IOException, SAXException {
        InputSource is = new InputSource(uri);
        this.getXMLReader().parse(is);
        return this.parent;
    }

    public Node parseText(String text2) throws IOException, SAXException {
        return this.parse(new StringReader(text2));
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public DTDHandler getDTDHandler() {
        return this.reader.getDTDHandler();
    }

    public EntityResolver getEntityResolver() {
        return this.reader.getEntityResolver();
    }

    public ErrorHandler getErrorHandler() {
        return this.reader.getErrorHandler();
    }

    public boolean getFeature(String uri) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.reader.getFeature(uri);
    }

    public Object getProperty(String uri) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.reader.getProperty(uri);
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.reader.setDTDHandler(dtdHandler);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.reader.setEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.reader.setErrorHandler(errorHandler);
    }

    public void setFeature(String uri, boolean value2) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.reader.setFeature(uri, value2);
    }

    public void setProperty(String uri, Object value2) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.reader.setProperty(uri, value2);
    }

    public void startDocument() throws SAXException {
        this.parent = null;
    }

    public void endDocument() throws SAXException {
        this.stack.clear();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes list2) throws SAXException {
        this.addTextToNode();
        Object nodeName = this.getElementName(namespaceURI, localName, qName);
        int size2 = list2.getLength();
        LinkedHashMap<Object, String> attributes = new LinkedHashMap<Object, String>(size2);
        for (int i = 0; i < size2; ++i) {
            Object attributeName = this.getElementName(list2.getURI(i), list2.getLocalName(i), list2.getQName(i));
            String value2 = list2.getValue(i);
            attributes.put(attributeName, value2);
        }
        this.parent = this.createNode(this.parent, nodeName, attributes);
        this.stack.add(this.parent);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.addTextToNode();
        if (!this.stack.isEmpty()) {
            this.stack.remove(this.stack.size() - 1);
            if (!this.stack.isEmpty()) {
                this.parent = this.stack.get(this.stack.size() - 1);
            }
        }
    }

    public void characters(char[] buffer, int start, int length) throws SAXException {
        this.bodyText.append(buffer, start, length);
    }

    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] buffer, int start, int len) throws SAXException {
    }

    public void processingInstruction(String target, String data2) throws SAXException {
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void skippedEntity(String name) throws SAXException {
    }

    protected XMLReader getXMLReader() {
        this.reader.setContentHandler(this);
        return this.reader;
    }

    protected void addTextToNode() {
        String text2 = this.bodyText.toString();
        if (this.trimWhitespace) {
            text2 = text2.trim();
        }
        if (text2.length() > 0) {
            this.parent.children().add(text2);
        }
        this.bodyText = new StringBuffer();
    }

    protected Node createNode(Node parent, Object name, Map attributes) {
        return new Node(parent, name, attributes);
    }

    protected Object getElementName(String namespaceURI, String localName, String qName) {
        int index;
        String name = localName;
        String prefix = "";
        if (name == null || name.length() < 1) {
            name = qName;
        }
        if (namespaceURI == null || namespaceURI.length() <= 0) {
            return name;
        }
        if (qName != null && qName.length() > 0 && this.namespaceAware && (index = qName.lastIndexOf(":")) > 0) {
            prefix = qName.substring(0, index);
        }
        return new QName(namespaceURI, name, prefix);
    }
}

