/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.util.IndentPrinter;
import groovy.util.Node;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerHelper;

public class NodePrinter {
    protected final IndentPrinter out;

    public NodePrinter() {
        this(new IndentPrinter(new PrintWriter(new OutputStreamWriter(System.out))));
    }

    public NodePrinter(PrintWriter out) {
        this(new IndentPrinter(out));
    }

    public NodePrinter(IndentPrinter out) {
        if (out == null) {
            throw new NullPointerException("IndentPrinter 'out' must not be null!");
        }
        this.out = out;
    }

    public void print(Node node) {
        Object value2;
        boolean hasAttributes;
        this.out.printIndent();
        this.printName(node);
        Map attributes = node.attributes();
        boolean bl = hasAttributes = attributes != null && !attributes.isEmpty();
        if (hasAttributes) {
            this.printAttributes(attributes);
        }
        if ((value2 = node.value()) instanceof List) {
            if (!hasAttributes) {
                this.out.print("()");
            }
            this.printList((List)value2);
        } else if (value2 instanceof String) {
            this.out.print("('");
            this.out.print((String)value2);
            this.out.println("')");
        } else {
            this.out.println("()");
        }
        this.out.flush();
    }

    protected void printName(Node node) {
        Object name = node.name();
        if (name != null) {
            this.out.print(name.toString());
        } else {
            this.out.print("null");
        }
    }

    protected void printList(List list2) {
        if (list2.isEmpty()) {
            this.out.println("");
        } else {
            this.out.println(" {");
            this.out.incrementIndent();
            for (Object value2 : list2) {
                if (value2 instanceof Node) {
                    this.print((Node)value2);
                    continue;
                }
                this.out.printIndent();
                this.out.print("builder.append(");
                this.out.print(InvokerHelper.toString(value2));
                this.out.println(")");
            }
            this.out.decrementIndent();
            this.out.printIndent();
            this.out.println("}");
        }
    }

    protected void printAttributes(Map attributes) {
        this.out.print("(");
        boolean first = true;
        for (Map.Entry entry2 : attributes.entrySet()) {
            if (first) {
                first = false;
            } else {
                this.out.print(", ");
            }
            this.out.print(entry2.getKey().toString());
            this.out.print(":");
            if (entry2.getValue() instanceof String) {
                this.out.print("'" + entry2.getValue() + "'");
                continue;
            }
            this.out.print(InvokerHelper.toString(entry2.getValue()));
        }
        this.out.print(")");
    }
}

