/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Closure;
import groovy.lang.EmptyRange;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.Range;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.runtime.IteratorClosureAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntRange
extends AbstractList<Integer>
implements Range<Integer> {
    private int from;
    private int to;
    private boolean reverse;

    public IntRange(int from2, int to2) {
        if (from2 > to2) {
            this.from = to2;
            this.to = from2;
            this.reverse = true;
        } else {
            this.from = from2;
            this.to = to2;
        }
        if (this.to - this.from >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("range must have no more than 2147483647 elements");
        }
    }

    protected IntRange(int from2, int to2, boolean reverse2) {
        if (from2 > to2) {
            throw new IllegalArgumentException("'from' must be less than or equal to 'to'");
        }
        this.from = from2;
        this.to = to2;
        this.reverse = reverse2;
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof IntRange ? this.equals((IntRange)that) : super.equals(that);
    }

    public boolean equals(IntRange that) {
        return that != null && this.reverse == that.reverse && this.from == that.from && this.to == that.to;
    }

    @Override
    public Integer getFrom() {
        return this.from;
    }

    @Override
    public Integer getTo() {
        return this.to;
    }

    public int getFromInt() {
        return this.from;
    }

    public int getToInt() {
        return this.to;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public boolean containsWithinBounds(Object o) {
        return this.contains(o);
    }

    @Override
    public Integer get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + " should not be negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + " too big for range: " + this);
        }
        int value2 = this.reverse ? this.to - index : index + this.from;
        return value2;
    }

    @Override
    public int size() {
        return this.to - this.from + 1;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IntRangeIterator();
    }

    @Override
    public List<Integer> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex == toIndex) {
            return new EmptyRange(Integer.valueOf(this.from));
        }
        return new IntRange(fromIndex + this.from, toIndex + this.from - 1, this.reverse);
    }

    @Override
    public String toString() {
        return this.reverse ? "" + this.to + ".." + this.from : "" + this.from + ".." + this.to;
    }

    @Override
    public String inspect() {
        return this.toString();
    }

    @Override
    public boolean contains(Object value2) {
        if (value2 instanceof Integer) {
            Integer integer = (Integer)value2;
            int i = integer;
            return i >= this.from && i <= this.to;
        }
        if (value2 instanceof BigInteger) {
            BigInteger bigint = (BigInteger)value2;
            return bigint.compareTo(BigInteger.valueOf(this.from)) >= 0 && bigint.compareTo(BigInteger.valueOf(this.to)) <= 0;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection other) {
        if (other instanceof IntRange) {
            IntRange range2 = (IntRange)other;
            return this.from <= range2.from && range2.to <= this.to;
        }
        return super.containsAll(other);
    }

    @Override
    public void step(int step, Closure closure) {
        if (step == 0) {
            if (this.from != this.to) {
                throw new GroovyRuntimeException("Infinite loop detected due to step size of 0");
            }
            return;
        }
        if (this.reverse) {
            step = -step;
        }
        if (step > 0) {
            for (int value2 = this.from; value2 <= this.to; value2 += step) {
                closure.call((Object)value2);
            }
        } else {
            for (int value3 = this.to; value3 >= this.from; value3 += step) {
                closure.call((Object)value3);
            }
        }
    }

    @Override
    public List<Integer> step(int step) {
        IteratorClosureAdapter adapter = new IteratorClosureAdapter(this);
        this.step(step, adapter);
        return adapter.asList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntRangeIterator
    implements Iterator<Integer> {
        private int index;
        private int size;
        private int value;

        private IntRangeIterator() {
            this.size = IntRange.this.size();
            this.value = IntRange.this.reverse ? IntRange.this.to : IntRange.this.from;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public Integer next() {
            if (this.index++ > 0) {
                if (this.index > this.size) {
                    return null;
                }
                this.value = IntRange.this.reverse ? --this.value : ++this.value;
            }
            return this.value;
        }

        @Override
        public void remove() {
            IntRange.this.remove(this.index);
        }
    }
}

