/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;

public abstract class LineReader<T>
implements Iterator<T> {
    private int count = 0;
    private int lineNumber = 0;
    private BufferedReader reader;
    private String nextLine;

    public abstract T parseLine(String var1);

    protected void readComment(String line) {
    }

    public LineReader(InputStream in) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        this.next();
    }

    public LineReader(Reader r) throws IOException {
        this.reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        this.next();
    }

    public LineReader(File f2) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f2), "UTF-8"));
        this.next();
    }

    @Override
    public boolean hasNext() {
        return this.nextLine != null;
    }

    @Override
    public T next() {
        T val = null;
        if (this.nextLine != null) {
            val = this.parseLine(this.nextLine);
            ++this.count;
        }
        if (this.reader != null) {
            try {
                while (this.reader != null) {
                    this.nextLine = this.reader.readLine();
                    ++this.lineNumber;
                    if (this.nextLine == null) {
                        this.reader.close();
                        this.reader = null;
                        continue;
                    }
                    if (this.nextLine.startsWith("#")) {
                        this.readComment(this.nextLine);
                        continue;
                    }
                    this.nextLine = this.nextLine.trim();
                    if (this.nextLine.length() <= 0) continue;
                    break;
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("IOException thrown while reading/closing reader", ioe);
            }
        }
        return val;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getCount() {
        return this.count;
    }
}

