/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.ShapeReadWriter;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.impl.RectangleImpl;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.spatial4j.core.shape.jts.JtsPoint;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.nio.ByteBuffer;

public class JtsShapeReadWriter
extends ShapeReadWriter<JtsSpatialContext> {
    private static final byte TYPE_POINT = 0;
    private static final byte TYPE_BBOX = 1;
    private static final byte TYPE_GEOM = 2;
    private boolean normalizeGeomCoords = true;

    public JtsShapeReadWriter(JtsSpatialContext ctx) {
        super(ctx);
    }

    private void checkCoordinates(Geometry geom) {
        geom.apply(new CoordinateSequenceFilter(){
            boolean changed = false;

            public void filter(CoordinateSequence seq2, int i) {
                double x2 = seq2.getX(i);
                double y = seq2.getY(i);
                if (((JtsSpatialContext)JtsShapeReadWriter.this.ctx).isGeo() && JtsShapeReadWriter.this.normalizeGeomCoords) {
                    double yNorm;
                    double xNorm = DistanceUtils.normLonDEG(x2);
                    if (x2 != xNorm) {
                        this.changed = true;
                        seq2.setOrdinate(i, 0, xNorm);
                    }
                    if (y != (yNorm = DistanceUtils.normLatDEG(y))) {
                        this.changed = true;
                        seq2.setOrdinate(i, 1, yNorm);
                    }
                } else {
                    ((JtsSpatialContext)JtsShapeReadWriter.this.ctx).verifyX(x2);
                    ((JtsSpatialContext)JtsShapeReadWriter.this.ctx).verifyY(y);
                }
            }

            public boolean isDone() {
                return false;
            }

            public boolean isGeometryChanged() {
                return this.changed;
            }
        });
    }

    @Override
    public Shape readShape(String str) throws InvalidShapeException {
        Shape shape = super.readStandardShape(str);
        if (shape == null) {
            try {
                WKTReader reader = new WKTReader(((JtsSpatialContext)this.ctx).getGeometryFactory());
                Geometry geom = reader.read(str);
                this.checkCoordinates(geom);
                if (geom instanceof Point) {
                    return new JtsPoint((Point)geom, this.ctx);
                }
                if (geom.isRectangle()) {
                    boolean crossesDateline = false;
                    if (((JtsSpatialContext)this.ctx).isGeo()) {
                        crossesDateline = !CGAlgorithms.isCCW((Coordinate[])geom.getCoordinates());
                    }
                    Envelope env = geom.getEnvelopeInternal();
                    if (crossesDateline) {
                        return new RectangleImpl(env.getMaxX(), env.getMinX(), env.getMinY(), env.getMaxY(), this.ctx);
                    }
                    return new RectangleImpl(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), this.ctx);
                }
                return new JtsGeometry(geom, (JtsSpatialContext)this.ctx, true);
            }
            catch (ParseException ex) {
                throw new InvalidShapeException("error reading WKT", ex);
            }
        }
        return shape;
    }

    @Override
    public String writeShape(Shape shape) {
        if (shape instanceof JtsGeometry) {
            JtsGeometry jtsGeom = (JtsGeometry)shape;
            return jtsGeom.getGeom().toText();
        }
        return super.writeShape(shape);
    }

    public Shape readShapeFromBytes(final byte[] array, final int offset, final int length) throws InvalidShapeException {
        ByteBuffer bytes = ByteBuffer.wrap(array, offset, length);
        byte type = bytes.get();
        if (type == 0) {
            return new JtsPoint(((JtsSpatialContext)this.ctx).getGeometryFactory().createPoint(new Coordinate(bytes.getDouble(), bytes.getDouble())), this.ctx);
        }
        if (type == 1) {
            return new RectangleImpl(bytes.getDouble(), bytes.getDouble(), bytes.getDouble(), bytes.getDouble(), this.ctx);
        }
        if (type == 2) {
            WKBReader reader = new WKBReader(((JtsSpatialContext)this.ctx).getGeometryFactory());
            try {
                Geometry geom = reader.read(new InStream(){
                    int off;
                    {
                        this.off = offset + 1;
                    }

                    public void read(byte[] buf) throws IOException {
                        if (this.off + buf.length > length) {
                            throw new InvalidShapeException("Asking for too many bytes");
                        }
                        System.arraycopy(array, this.off, buf, 0, buf.length);
                        this.off += buf.length;
                    }
                });
                this.checkCoordinates(geom);
                return new JtsGeometry(geom, (JtsSpatialContext)this.ctx, true);
            }
            catch (ParseException ex) {
                throw new InvalidShapeException("error reading WKT", ex);
            }
            catch (IOException ex) {
                throw new InvalidShapeException("error reading WKT", ex);
            }
        }
        throw new InvalidShapeException("shape not handled: " + type);
    }

    public byte[] writeShapeToBytes(Shape shape) throws IOException {
        if (com.spatial4j.core.shape.Point.class.isInstance(shape)) {
            ByteBuffer bytes = ByteBuffer.wrap(new byte[17]);
            com.spatial4j.core.shape.Point p = (com.spatial4j.core.shape.Point)shape;
            bytes.put((byte)0);
            bytes.putDouble(p.getX());
            bytes.putDouble(p.getY());
            return bytes.array();
        }
        if (Rectangle.class.isInstance(shape)) {
            Rectangle rect = (Rectangle)shape;
            ByteBuffer bytes = ByteBuffer.wrap(new byte[33]);
            bytes.put((byte)1);
            bytes.putDouble(rect.getMinX());
            bytes.putDouble(rect.getMaxX());
            bytes.putDouble(rect.getMinY());
            bytes.putDouble(rect.getMaxY());
            return bytes.array();
        }
        if (JtsGeometry.class.isInstance(shape)) {
            WKBWriter writer = new WKBWriter();
            byte[] bb = writer.write(((JtsGeometry)shape).getGeom());
            ByteBuffer bytes = ByteBuffer.wrap(new byte[1 + bb.length]);
            bytes.put((byte)2);
            bytes.put(bb);
            return bytes.array();
        }
        throw new IllegalArgumentException("unsuported shape:" + shape);
    }
}

