/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.context.jts;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.JtsShapeReadWriter;
import com.spatial4j.core.io.ShapeReadWriter;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.spatial4j.core.shape.jts.JtsPoint;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import java.util.ArrayList;

public class JtsSpatialContext
extends SpatialContext {
    public static final JtsSpatialContext GEO = new JtsSpatialContext(true);
    private final GeometryFactory geometryFactory;

    public JtsSpatialContext(boolean geo) {
        this(null, geo, null, null);
    }

    public JtsSpatialContext(GeometryFactory geometryFactory, boolean geo, DistanceCalculator calculator, Rectangle worldBounds) {
        super(geo, calculator, worldBounds);
        this.geometryFactory = geometryFactory == null ? new GeometryFactory() : geometryFactory;
    }

    @Override
    protected ShapeReadWriter makeShapeReadWriter() {
        return new JtsShapeReadWriter(this);
    }

    public Geometry getGeometryFrom(Shape shape) {
        if (shape instanceof JtsGeometry) {
            return ((JtsGeometry)shape).getGeom();
        }
        if (shape instanceof JtsPoint) {
            return ((JtsPoint)shape).getGeom();
        }
        if (shape instanceof Point) {
            Point point = (Point)shape;
            return this.geometryFactory.createPoint(new Coordinate(point.getX(), point.getY()));
        }
        if (shape instanceof Rectangle) {
            Rectangle r = (Rectangle)shape;
            if (r.getCrossesDateLine()) {
                ArrayList<Geometry> pair2 = new ArrayList<Geometry>(2);
                pair2.add(this.geometryFactory.toGeometry(new Envelope(r.getMinX(), this.getWorldBounds().getMaxX(), r.getMinY(), r.getMaxY())));
                pair2.add(this.geometryFactory.toGeometry(new Envelope(this.getWorldBounds().getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY())));
                return this.geometryFactory.buildGeometry(pair2);
            }
            return this.geometryFactory.toGeometry(new Envelope(r.getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY()));
        }
        if (shape instanceof Circle) {
            Circle circle = (Circle)shape;
            if (circle.getBoundingBox().getCrossesDateLine()) {
                throw new IllegalArgumentException("Doesn't support dateline cross yet: " + circle);
            }
            GeometricShapeFactory gsf = new GeometricShapeFactory(this.geometryFactory);
            gsf.setSize(circle.getBoundingBox().getWidth() / 2.0);
            gsf.setNumPoints(100);
            gsf.setBase(new Coordinate(circle.getCenter().getX(), circle.getCenter().getY()));
            return gsf.createCircle();
        }
        throw new InvalidShapeException("can't make Geometry from: " + shape);
    }

    @Override
    public Point makePoint(double x2, double y) {
        this.verifyX(x2);
        this.verifyY(y);
        return new JtsPoint(this.geometryFactory.createPoint(new Coordinate(x2, y)), this);
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    @Override
    public String toString() {
        if (this.equals(GEO)) {
            return GEO.getClass().getSimpleName() + ".GEO";
        }
        return super.toString();
    }
}

