/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools.jsonrpc;

import com.rabbitmq.tools.json.JSONUtil;
import com.rabbitmq.tools.jsonrpc.ParameterDescription;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcedureDescription {
    public String name;
    public String summary;
    public String help;
    public boolean idempotent;
    private ParameterDescription[] params;
    private String returnType;
    private Method method;

    public ProcedureDescription(Map<String, Object> pm) {
        JSONUtil.tryFill(this, pm);
        List p = (List)pm.get("params");
        this.params = new ParameterDescription[p.size()];
        int count2 = 0;
        for (Map param_map : p) {
            ParameterDescription param2 = new ParameterDescription(param_map);
            this.params[count2++] = param2;
        }
    }

    public ProcedureDescription(Method m) {
        this.method = m;
        this.name = m.getName();
        this.summary = "";
        this.help = "";
        this.idempotent = false;
        Class<?>[] parameterTypes = m.getParameterTypes();
        this.params = new ParameterDescription[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            this.params[i] = new ParameterDescription(i, parameterTypes[i]);
        }
        this.returnType = ParameterDescription.lookup(m.getReturnType());
    }

    public ProcedureDescription() {
    }

    public String getReturn() {
        return this.returnType;
    }

    public void setReturn(String value2) {
        this.returnType = value2;
    }

    public Method internal_getMethod() {
        return this.method;
    }

    public ParameterDescription[] internal_getParams() {
        return this.params;
    }

    public int arity() {
        return this.params == null ? 0 : this.params.length;
    }

    public ParameterDescription[] getParams() {
        return this.params;
    }
}

