/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools.json;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JSONReader {
    private static final Object OBJECT_END = new Object();
    private static final Object ARRAY_END = new Object();
    private static final Object COLON = new Object();
    private static final Object COMMA = new Object();
    private static Map<Character, Character> escapes = new HashMap<Character, Character>();
    private CharacterIterator it;
    private char c;
    private Object token;
    private StringBuilder buf = new StringBuilder();

    private char next() {
        this.c = this.it.next();
        return this.c;
    }

    private void skipWhiteSpace() {
        boolean cont;
        do {
            cont = true;
            if (Character.isWhitespace(this.c)) {
                this.next();
                continue;
            }
            if (this.c == '/' && this.next() == '/') {
                while (this.c != '\n') {
                    this.next();
                }
            } else {
                cont = false;
            }
        } while (cont);
    }

    public Object read(String string2) {
        this.it = new StringCharacterIterator(string2);
        this.c = this.it.first();
        return this.read();
    }

    private Object read() {
        Object ret = null;
        this.skipWhiteSpace();
        if (this.c == '\"' || this.c == '\'') {
            char sep = this.c;
            this.next();
            ret = this.string(sep);
        } else if (this.c == '[') {
            this.next();
            ret = this.array();
        } else if (this.c == ']') {
            ret = ARRAY_END;
            this.next();
        } else if (this.c == ',') {
            ret = COMMA;
            this.next();
        } else if (this.c == '{') {
            this.next();
            ret = this.object();
        } else if (this.c == '}') {
            ret = OBJECT_END;
            this.next();
        } else if (this.c == ':') {
            ret = COLON;
            this.next();
        } else if (this.c == 't' && this.next() == 'r' && this.next() == 'u' && this.next() == 'e') {
            ret = Boolean.TRUE;
            this.next();
        } else if (this.c == 'f' && this.next() == 'a' && this.next() == 'l' && this.next() == 's' && this.next() == 'e') {
            ret = Boolean.FALSE;
            this.next();
        } else if (this.c == 'n' && this.next() == 'u' && this.next() == 'l' && this.next() == 'l') {
            this.next();
        } else if (Character.isDigit(this.c) || this.c == '-') {
            ret = this.number();
        } else {
            throw new IllegalStateException("Found invalid token while parsing JSON (around character " + (this.it.getIndex() - this.it.getBeginIndex()) + "): " + ret);
        }
        this.token = ret;
        return ret;
    }

    private Object object() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String key = (String)this.read();
        while (this.token != OBJECT_END) {
            this.read();
            if (this.token == OBJECT_END) continue;
            ret.put(key, this.read());
            if (this.read() != COMMA) continue;
            key = (String)this.read();
        }
        return ret;
    }

    private Object array() {
        ArrayList<Object> ret = new ArrayList<Object>();
        Object value2 = this.read();
        while (this.token != ARRAY_END) {
            ret.add(value2);
            if (this.read() != COMMA) continue;
            value2 = this.read();
        }
        return ret;
    }

    private Object number() {
        this.buf.setLength(0);
        if (this.c == '-') {
            this.add();
        }
        this.addDigits();
        if (this.c == '.') {
            this.add();
            this.addDigits();
        }
        if (this.c == 'e' || this.c == 'E') {
            this.add();
            if (this.c == '+' || this.c == '-') {
                this.add();
            }
            this.addDigits();
        }
        String result2 = this.buf.toString();
        try {
            return new Integer(result2);
        }
        catch (NumberFormatException nfe) {
            return new Double(result2);
        }
    }

    private Object string(char sep) {
        this.buf.setLength(0);
        while (this.c != sep) {
            if (this.c == '\\') {
                this.next();
                if (this.c == 'u') {
                    this.add(this.unicode());
                    continue;
                }
                Character value2 = escapes.get(new Character(this.c));
                if (value2 != null) {
                    this.add(value2.charValue());
                    continue;
                }
                this.add();
                continue;
            }
            this.add();
        }
        this.next();
        return this.buf.toString();
    }

    private void add(char cc) {
        this.buf.append(cc);
        this.next();
    }

    private void add() {
        this.add(this.c);
    }

    private void addDigits() {
        while (Character.isDigit(this.c)) {
            this.add();
        }
    }

    private char unicode() {
        int value2 = 0;
        block5: for (int i = 0; i < 4; ++i) {
            switch (this.next()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value2 = (value2 << 4) + this.c - 48;
                    continue block5;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    value2 = (value2 << 4) + this.c - 97 + 10;
                    continue block5;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    value2 = (value2 << 4) + this.c - 65 + 10;
                }
            }
        }
        return (char)value2;
    }

    static {
        escapes.put(new Character('\"'), new Character('\"'));
        escapes.put(new Character('\\'), new Character('\\'));
        escapes.put(new Character('/'), new Character('/'));
        escapes.put(new Character('b'), new Character('\b'));
        escapes.put(new Character('f'), new Character('\f'));
        escapes.put(new Character('n'), new Character('\n'));
        escapes.put(new Character('r'), new Character('\r'));
        escapes.put(new Character('t'), new Character('\t'));
    }
}

