/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.SetQueue;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkPool<K, W> {
    private final Object monitor = new Object();
    private final SetQueue<K> ready = new SetQueue();
    private final Set<K> inProgress = new HashSet<K>();
    private final Map<K, LinkedList<W>> pool = new HashMap<K, LinkedList<W>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerKey(K key) {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.pool.containsKey(key)) {
                this.pool.put(key, new LinkedList());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterKey(K key) {
        Object object = this.monitor;
        synchronized (object) {
            this.pool.remove(key);
            this.ready.remove(key);
            this.inProgress.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAllKeys() {
        Object object = this.monitor;
        synchronized (object) {
            this.pool.clear();
            this.ready.clear();
            this.inProgress.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K nextWorkBlock(Collection<W> to2, int size2) {
        Object object = this.monitor;
        synchronized (object) {
            K nextKey = this.readyToInProgress();
            if (nextKey != null) {
                LinkedList<W> queue = this.pool.get(nextKey);
                WorkPool.drainTo(queue, to2, size2);
            }
            return nextKey;
        }
    }

    private static <W> int drainTo(LinkedList<W> deList, Collection<W> c, int maxElements) {
        W first;
        int n;
        for (n = 0; n < maxElements && (first = deList.poll()) != null; ++n) {
            c.add(first);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWorkItem(K key, W item) {
        Object object = this.monitor;
        synchronized (object) {
            Queue queue = this.pool.get(key);
            if (queue != null) {
                queue.offer(item);
                if (this.isDormant(key)) {
                    this.dormantToReady(key);
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishWorkBlock(K key) {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.isRegistered(key)) {
                return false;
            }
            if (!this.inProgress.contains(key)) {
                throw new IllegalStateException("Client " + key + " not in progress");
            }
            if (this.moreWorkItems(key)) {
                this.inProgressToReady(key);
                return true;
            }
            this.inProgressToDormant(key);
            return false;
        }
    }

    private boolean moreWorkItems(K key) {
        LinkedList<W> leList = this.pool.get(key);
        return leList == null ? false : !leList.isEmpty();
    }

    private boolean isInProgress(K key) {
        return this.inProgress.contains(key);
    }

    private boolean isReady(K key) {
        return this.ready.contains(key);
    }

    private boolean isRegistered(K key) {
        return this.pool.containsKey(key);
    }

    private boolean isDormant(K key) {
        return !this.isInProgress(key) && !this.isReady(key) && this.isRegistered(key);
    }

    private void inProgressToReady(K key) {
        this.inProgress.remove(key);
        this.ready.addIfNotPresent(key);
    }

    private void inProgressToDormant(K key) {
        this.inProgress.remove(key);
    }

    private void dormantToReady(K key) {
        this.ready.addIfNotPresent(key);
    }

    private K readyToInProgress() {
        K key = this.ready.poll();
        if (key != null) {
            this.inProgress.add(key);
        }
        return key;
    }
}

