/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.LongString;
import com.rabbitmq.client.impl.Frame;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueWriter {
    private final DataOutputStream out;
    private static final int COPY_BUFFER_SIZE = 4096;

    public ValueWriter(DataOutputStream out) {
        this.out = out;
    }

    public final void writeShortstr(String str) throws IOException {
        byte[] bytes = str.getBytes("utf-8");
        int length = bytes.length;
        if (length > 255) {
            throw new IllegalArgumentException("Short string too long; utf-8 encoded length = " + length + ", max = 255.");
        }
        this.out.writeByte(bytes.length);
        this.out.write(bytes);
    }

    public final void writeLongstr(LongString str) throws IOException {
        this.writeLong((int)str.length());
        ValueWriter.copy(str.getStream(), this.out);
    }

    private static void copy(InputStream input2, OutputStream output2) throws IOException {
        byte[] buffer = new byte[4096];
        int biteSize = input2.read(buffer);
        while (-1 != biteSize) {
            output2.write(buffer, 0, biteSize);
            biteSize = input2.read(buffer);
        }
    }

    public final void writeLongstr(String str) throws IOException {
        byte[] bytes = str.getBytes("utf-8");
        this.writeLong(bytes.length);
        this.out.write(bytes);
    }

    public final void writeShort(int s) throws IOException {
        this.out.writeShort(s);
    }

    public final void writeLong(int l) throws IOException {
        this.out.writeInt(l);
    }

    public final void writeLonglong(long ll) throws IOException {
        this.out.writeLong(ll);
    }

    public final void writeTable(Map<String, Object> table) throws IOException {
        if (table == null) {
            this.out.writeInt(0);
        } else {
            this.out.writeInt((int)Frame.tableSize(table));
            for (Map.Entry<String, Object> entry2 : table.entrySet()) {
                this.writeShortstr(entry2.getKey());
                Object value2 = entry2.getValue();
                this.writeFieldValue(value2);
            }
        }
    }

    public final void writeFieldValue(Object value2) throws IOException {
        if (value2 instanceof String) {
            this.writeOctet(83);
            this.writeLongstr((String)value2);
        } else if (value2 instanceof LongString) {
            this.writeOctet(83);
            this.writeLongstr((LongString)value2);
        } else if (value2 instanceof Integer) {
            this.writeOctet(73);
            this.writeLong((Integer)value2);
        } else if (value2 instanceof BigDecimal) {
            this.writeOctet(68);
            BigDecimal decimal = (BigDecimal)value2;
            this.writeOctet(decimal.scale());
            BigInteger unscaled = decimal.unscaledValue();
            if (unscaled.bitLength() > 32) {
                throw new IllegalArgumentException("BigDecimal too large to be encoded");
            }
            this.writeLong(decimal.unscaledValue().intValue());
        } else if (value2 instanceof Date) {
            this.writeOctet(84);
            this.writeTimestamp((Date)value2);
        } else if (value2 instanceof Map) {
            this.writeOctet(70);
            Map map2 = (Map)value2;
            this.writeTable(map2);
        } else if (value2 instanceof Byte) {
            this.writeOctet(98);
            this.out.writeByte(((Byte)value2).byteValue());
        } else if (value2 instanceof Double) {
            this.writeOctet(100);
            this.out.writeDouble((Double)value2);
        } else if (value2 instanceof Float) {
            this.writeOctet(102);
            this.out.writeFloat(((Float)value2).floatValue());
        } else if (value2 instanceof Long) {
            this.writeOctet(108);
            this.out.writeLong((Long)value2);
        } else if (value2 instanceof Short) {
            this.writeOctet(115);
            this.out.writeShort(((Short)value2).shortValue());
        } else if (value2 instanceof Boolean) {
            this.writeOctet(116);
            this.out.writeBoolean((Boolean)value2);
        } else if (value2 instanceof byte[]) {
            this.writeOctet(120);
            this.writeLong(((byte[])value2).length);
            this.out.write((byte[])value2);
        } else if (value2 == null) {
            this.writeOctet(86);
        } else if (value2 instanceof List) {
            this.writeOctet(65);
            this.writeArray((List)value2);
        } else if (value2 instanceof Object[]) {
            this.writeOctet(65);
            this.writeArray((Object[])value2);
        } else {
            throw new IllegalArgumentException("Invalid value type: " + value2.getClass().getName());
        }
    }

    public final void writeArray(List<?> value2) throws IOException {
        if (value2 == null) {
            this.out.write(0);
        } else {
            this.out.writeInt((int)Frame.arraySize(value2));
            for (Object item : value2) {
                this.writeFieldValue(item);
            }
        }
    }

    public final void writeArray(Object[] value2) throws IOException {
        if (value2 == null) {
            this.out.write(0);
        } else {
            this.out.writeInt((int)Frame.arraySize(value2));
            for (Object item : value2) {
                this.writeFieldValue(item);
            }
        }
    }

    public final void writeOctet(int octet) throws IOException {
        this.out.writeByte(octet);
    }

    public final void writeOctet(byte octet) throws IOException {
        this.out.writeByte(octet);
    }

    public final void writeTimestamp(Date timestamp) throws IOException {
        this.writeLonglong(timestamp.getTime() / 1000L);
    }

    public void flush() throws IOException {
        this.out.flush();
    }
}

