/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TruncatedInputStream
extends FilterInputStream {
    private final long limit;
    private long counter = 0L;
    private long mark = 0L;

    public TruncatedInputStream(InputStream in, long limit) {
        super(in);
        this.limit = limit;
    }

    public int available() throws IOException {
        return (int)Math.min(this.limit - this.counter, (long)super.available());
    }

    public void mark(int readlimit) {
        super.mark(readlimit);
        this.mark = this.counter;
    }

    public int read() throws IOException {
        if (this.counter < this.limit) {
            int result2 = super.read();
            if (result2 >= 0) {
                ++this.counter;
            }
            return result2;
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.limit > this.counter) {
            int result2 = super.read(b, off, (int)Math.min((long)len, this.limit - this.counter));
            if (result2 > 0) {
                this.counter += (long)result2;
            }
            return result2;
        }
        return -1;
    }

    public void reset() throws IOException {
        super.reset();
        this.counter = this.mark;
    }

    public long skip(long n) throws IOException {
        long result2 = super.skip(Math.min(n, this.limit - this.counter));
        this.counter += result2;
        return result2;
    }
}

