/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.LongString;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class LongStringHelper {
    public static LongString asLongString(String string2) {
        if (string2 == null) {
            return null;
        }
        try {
            return new ByteArrayLongString(string2.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("utf-8 encoding support required");
        }
    }

    public static LongString asLongString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new ByteArrayLongString(bytes);
    }

    private static class ByteArrayLongString
    implements LongString {
        private byte[] bytes;

        public ByteArrayLongString(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object o) {
            if (o instanceof LongString) {
                LongString other = (LongString)o;
                return Arrays.equals(this.bytes, other.getBytes());
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public DataInputStream getStream() throws IOException {
            return new DataInputStream(new ByteArrayInputStream(this.bytes));
        }

        public long length() {
            return this.bytes.length;
        }

        public String toString() {
            try {
                return new String(this.bytes, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("utf-8 encoding support required");
            }
        }
    }
}

