/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.LongString;
import com.rabbitmq.client.MalformedFrameException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frame {
    public final int type;
    public final int channel;
    private final byte[] payload;
    private final ByteArrayOutputStream accumulator;

    public Frame(int type, int channel) {
        this.type = type;
        this.channel = channel;
        this.payload = null;
        this.accumulator = new ByteArrayOutputStream();
    }

    public Frame(int type, int channel, byte[] payload) {
        this.type = type;
        this.channel = channel;
        this.payload = payload;
        this.accumulator = null;
    }

    public static Frame fromBodyFragment(int channelNumber, byte[] body, int offset, int length) throws IOException {
        Frame frame = new Frame(3, channelNumber);
        DataOutputStream bodyOut = frame.getOutputStream();
        bodyOut.write(body, offset, length);
        return frame;
    }

    public static Frame readFrom(DataInputStream is) throws IOException {
        int type;
        try {
            type = is.readUnsignedByte();
        }
        catch (SocketTimeoutException ste) {
            return null;
        }
        if (type == 65) {
            Frame.protocolVersionMismatch(is);
        }
        int channel = is.readUnsignedShort();
        int payloadSize = is.readInt();
        byte[] payload = new byte[payloadSize];
        is.readFully(payload);
        int frameEndMarker = is.readUnsignedByte();
        if (frameEndMarker != 206) {
            throw new MalformedFrameException("Bad frame end marker: " + frameEndMarker);
        }
        return new Frame(type, channel, payload);
    }

    public static void protocolVersionMismatch(DataInputStream is) throws IOException {
        MalformedFrameException x2;
        byte[] expectedBytes;
        for (byte expectedByte : expectedBytes = new byte[]{77, 81, 80}) {
            int nextByte = is.readUnsignedByte();
            if (nextByte == expectedByte) continue;
            throw new MalformedFrameException("Invalid AMQP protocol header from server: expected character " + expectedByte + ", got " + nextByte);
        }
        try {
            int[] signature = new int[4];
            for (int i = 0; i < 4; ++i) {
                signature[i] = is.readUnsignedByte();
            }
            if (signature[0] == 1 && signature[1] == 1 && signature[2] == 8 && signature[3] == 0) {
                x2 = new MalformedFrameException("AMQP protocol version mismatch; we are version 0-9-1, server is 0-8");
            } else {
                String sig = "";
                for (int i = 0; i < 4; ++i) {
                    if (i != 0) {
                        sig = sig + ",";
                    }
                    sig = sig + signature[i];
                }
                x2 = new MalformedFrameException("AMQP protocol version mismatch; we are version 0-9-1, server sent signature " + sig);
            }
        }
        catch (IOException ex) {
            x2 = new MalformedFrameException("Invalid AMQP protocol header from server");
        }
        throw x2;
    }

    public void writeTo(DataOutputStream os) throws IOException {
        os.writeByte(this.type);
        os.writeShort(this.channel);
        if (this.accumulator != null) {
            os.writeInt(this.accumulator.size());
            this.accumulator.writeTo(os);
        } else {
            os.writeInt(this.payload.length);
            os.write(this.payload);
        }
        os.write(206);
    }

    public byte[] getPayload() {
        if (this.payload != null) {
            return this.payload;
        }
        return this.accumulator.toByteArray();
    }

    public DataInputStream getInputStream() {
        return new DataInputStream(new ByteArrayInputStream(this.getPayload()));
    }

    public DataOutputStream getOutputStream() {
        return new DataOutputStream(this.accumulator);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Frame(type=").append(this.type).append(", channel=").append(this.channel).append(", ");
        if (this.accumulator == null) {
            sb.append(this.payload.length).append(" bytes of payload)");
        } else {
            sb.append(this.accumulator.size()).append(" bytes of accumulator)");
        }
        return sb.toString();
    }

    public static long tableSize(Map<String, Object> table) throws UnsupportedEncodingException {
        long acc = 0L;
        for (Map.Entry<String, Object> entry2 : table.entrySet()) {
            acc += (long)Frame.shortStrSize(entry2.getKey());
            acc += Frame.fieldValueSize(entry2.getValue());
        }
        return acc;
    }

    private static long fieldValueSize(Object value2) throws UnsupportedEncodingException {
        long acc = 1L;
        if (value2 instanceof String) {
            acc += (long)Frame.longStrSize((String)value2);
        } else if (value2 instanceof LongString) {
            acc += 4L + ((LongString)value2).length();
        } else if (value2 instanceof Integer) {
            acc += 4L;
        } else if (value2 instanceof BigDecimal) {
            acc += 5L;
        } else if (value2 instanceof Date || value2 instanceof Timestamp) {
            acc += 8L;
        } else if (value2 instanceof Map) {
            Map map2 = (Map)value2;
            acc += 4L + Frame.tableSize(map2);
        } else if (value2 instanceof Byte) {
            ++acc;
        } else if (value2 instanceof Double) {
            acc += 8L;
        } else if (value2 instanceof Float) {
            acc += 4L;
        } else if (value2 instanceof Long) {
            acc += 8L;
        } else if (value2 instanceof Short) {
            acc += 2L;
        } else if (value2 instanceof Boolean) {
            ++acc;
        } else if (value2 instanceof byte[]) {
            acc += (long)(4 + ((byte[])value2).length);
        } else if (value2 instanceof List) {
            acc += 4L + Frame.arraySize((List)value2);
        } else if (value2 instanceof Object[]) {
            acc += 4L + Frame.arraySize((Object[])value2);
        } else if (value2 != null) {
            throw new IllegalArgumentException("invalid value in table");
        }
        return acc;
    }

    public static long arraySize(List<?> values2) throws UnsupportedEncodingException {
        long acc = 0L;
        for (Object value2 : values2) {
            acc += Frame.fieldValueSize(value2);
        }
        return acc;
    }

    public static long arraySize(Object[] values2) throws UnsupportedEncodingException {
        long acc = 0L;
        for (Object value2 : values2) {
            acc += Frame.fieldValueSize(value2);
        }
        return acc;
    }

    private static int longStrSize(String str) throws UnsupportedEncodingException {
        return str.getBytes("utf-8").length + 4;
    }

    private static int shortStrSize(String str) throws UnsupportedEncodingException {
        return str.getBytes("utf-8").length + 1;
    }
}

