/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.UnexpectedFrameError;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.Method;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class CommandAssembler {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private CAState state;
    private Method method;
    private AMQContentHeader contentHeader;
    private final List<byte[]> bodyN;
    private int bodyLength;
    private long remainingBodyBytes;

    public CommandAssembler(Method method, AMQContentHeader contentHeader, byte[] body) {
        this.method = method;
        this.contentHeader = contentHeader;
        this.bodyN = new ArrayList<byte[]>(2);
        this.bodyLength = 0;
        this.remainingBodyBytes = 0L;
        this.appendBodyFragment(body);
        if (method == null) {
            this.state = CAState.EXPECTING_METHOD;
        } else if (contentHeader == null) {
            this.state = method.hasContent() ? CAState.EXPECTING_CONTENT_HEADER : CAState.COMPLETE;
        } else {
            this.remainingBodyBytes = contentHeader.getBodySize() - (long)this.bodyLength;
            this.updateContentBodyState();
        }
    }

    public synchronized Method getMethod() {
        return this.method;
    }

    public synchronized AMQContentHeader getContentHeader() {
        return this.contentHeader;
    }

    public synchronized boolean isComplete() {
        return this.state == CAState.COMPLETE;
    }

    private void updateContentBodyState() {
        this.state = this.remainingBodyBytes > 0L ? CAState.EXPECTING_CONTENT_BODY : CAState.COMPLETE;
    }

    private void consumeMethodFrame(Frame f2) throws IOException {
        if (f2.type != 1) {
            throw new UnexpectedFrameError(f2, 1);
        }
        this.method = AMQImpl.readMethodFrom(f2.getInputStream());
        this.state = this.method.hasContent() ? CAState.EXPECTING_CONTENT_HEADER : CAState.COMPLETE;
    }

    private void consumeHeaderFrame(Frame f2) throws IOException {
        if (f2.type != 2) {
            throw new UnexpectedFrameError(f2, 2);
        }
        this.contentHeader = AMQImpl.readContentHeaderFrom(f2.getInputStream());
        this.remainingBodyBytes = this.contentHeader.getBodySize();
        this.updateContentBodyState();
    }

    private void consumeBodyFrame(Frame f2) {
        byte[] fragment;
        if (f2.type == 3) {
            fragment = f2.getPayload();
            this.remainingBodyBytes -= (long)fragment.length;
            this.updateContentBodyState();
            if (this.remainingBodyBytes < 0L) {
                throw new UnsupportedOperationException("%%%%%% FIXME unimplemented");
            }
        } else {
            throw new UnexpectedFrameError(f2, 3);
        }
        this.appendBodyFragment(fragment);
    }

    private byte[] coalesceContentBody() {
        if (this.bodyLength == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        if (this.bodyN.size() == 1) {
            return this.bodyN.get(0);
        }
        byte[] body = new byte[this.bodyLength];
        int offset = 0;
        for (byte[] fragment : this.bodyN) {
            System.arraycopy(fragment, 0, body, offset, fragment.length);
            offset += fragment.length;
        }
        this.bodyN.clear();
        this.bodyN.add(body);
        return body;
    }

    public synchronized byte[] getContentBody() {
        return this.coalesceContentBody();
    }

    private void appendBodyFragment(byte[] fragment) {
        if (fragment == null || fragment.length == 0) {
            return;
        }
        this.bodyN.add(fragment);
        this.bodyLength += fragment.length;
    }

    public synchronized boolean handleFrame(Frame f2) throws IOException {
        switch (this.state) {
            case EXPECTING_METHOD: {
                this.consumeMethodFrame(f2);
                break;
            }
            case EXPECTING_CONTENT_HEADER: {
                this.consumeHeaderFrame(f2);
                break;
            }
            case EXPECTING_CONTENT_BODY: {
                this.consumeBodyFrame(f2);
                break;
            }
            default: {
                throw new AssertionError((Object)("Bad Command State " + (Object)((Object)this.state)));
            }
        }
        return this.isComplete();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CAState {
        EXPECTING_METHOD,
        EXPECTING_CONTENT_HEADER,
        EXPECTING_CONTENT_BODY,
        COMPLETE;

    }
}

