/*
 * Decompiled with CFR 0.152.
 */
package com.ning.org.jboss.netty.handler.codec.http;

import com.ning.http.client.Cookie;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.org.jboss.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieDecoder {
    private static final char COMMA = ',';

    private CookieDecoder() {
    }

    public static Set<Cookie> decode(String header) {
        int i;
        ArrayList<String> names = new ArrayList<String>(8);
        ArrayList<String> values2 = new ArrayList<String>(8);
        ArrayList<String> rawValues = new ArrayList<String>(8);
        CookieDecoder.extractKeyValuePairs(header, names, values2, rawValues);
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        int version = 0;
        if (((String)names.get(0)).equalsIgnoreCase("Version")) {
            try {
                version = Integer.parseInt((String)values2.get(0));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            i = 1;
        } else {
            i = 0;
        }
        if (names.size() <= i) {
            return Collections.emptySet();
        }
        HashSet<Cookie> cookies = new HashSet<Cookie>();
        while (i < names.size()) {
            String name = (String)names.get(i);
            String value2 = (String)values2.get(i);
            String rawValue = (String)rawValues.get(i);
            if (value2 == null) {
                value2 = "";
            }
            if (rawValue == null) {
                rawValue = "";
            }
            String cookieName = name;
            String cookieValue = value2;
            String cookieRawValue = rawValue;
            boolean discard = false;
            boolean secure = false;
            boolean httpOnly = false;
            String comment2 = null;
            String commentURL = null;
            String domain = null;
            String path = null;
            int maxAge = -1;
            List<Integer> ports = Collections.emptyList();
            int j = i + 1;
            while (j < names.size()) {
                name = (String)names.get(j);
                value2 = (String)values2.get(j);
                if ("Discard".equalsIgnoreCase(name)) {
                    discard = true;
                } else if ("Secure".equalsIgnoreCase(name)) {
                    secure = true;
                } else if ("HTTPOnly".equalsIgnoreCase(name)) {
                    httpOnly = true;
                } else if ("Comment".equalsIgnoreCase(name)) {
                    comment2 = value2;
                } else if ("CommentURL".equalsIgnoreCase(name)) {
                    commentURL = value2;
                } else if ("Domain".equalsIgnoreCase(name)) {
                    domain = value2;
                } else if ("Path".equalsIgnoreCase(name)) {
                    path = value2;
                } else if ("Expires".equalsIgnoreCase(name)) {
                    try {
                        maxAge = AsyncHttpProviderUtils.convertExpireField(value2);
                    }
                    catch (Exception e) {
                        try {
                            maxAge = Math.max(Integer.valueOf(value2), 0);
                        }
                        catch (NumberFormatException e1) {}
                    }
                } else if ("Max-Age".equalsIgnoreCase(name)) {
                    maxAge = Integer.parseInt(value2);
                } else if ("Version".equalsIgnoreCase(name)) {
                    version = Integer.parseInt(value2);
                } else {
                    if (!"Port".equalsIgnoreCase(name)) break;
                    String[] portList = StringUtil.split(value2, ',');
                    ports = new ArrayList<Integer>(2);
                    for (String s1 : portList) {
                        try {
                            ports.add(Integer.valueOf(s1));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                }
                ++j;
                ++i;
            }
            Cookie c = new Cookie(domain, cookieName, cookieValue, cookieRawValue, path, maxAge, secure, version, httpOnly, discard, comment2, commentURL, ports);
            cookies.add(c);
            ++i;
        }
        return cookies;
    }

    private static void extractKeyValuePairs(String header, List<String> names, List<String> values2, List<String> rawValues) {
        int headerLen = header.length();
        int i = 0;
        block10: while (i != headerLen) {
            switch (header.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ';': {
                    ++i;
                    continue block10;
                }
            }
            while (i != headerLen) {
                String rawValue;
                String value2;
                String name;
                if (header.charAt(i) == '$') {
                    ++i;
                    continue;
                }
                if (i == headerLen) {
                    name = null;
                    value2 = null;
                    rawValue = null;
                } else {
                    int newNameStart = i;
                    block12: while (true) {
                        switch (header.charAt(i)) {
                            case ';': {
                                name = header.substring(newNameStart, i);
                                value2 = null;
                                rawValue = null;
                                break block12;
                            }
                            case '=': {
                                name = header.substring(newNameStart, i);
                                if (++i == headerLen) {
                                    value2 = "";
                                    rawValue = "";
                                    break block12;
                                }
                                int newValueStart = i;
                                char c = header.charAt(i);
                                if (c == '\"' || c == '\'') {
                                    StringBuilder newValueBuf = new StringBuilder(header.length() - i);
                                    StringBuilder newRawValueBuf = new StringBuilder(header.length() - i);
                                    newRawValueBuf.append(c);
                                    char q = c;
                                    boolean hadBackslash = false;
                                    ++i;
                                    block13: while (true) {
                                        if (i == headerLen) {
                                            value2 = newValueBuf.toString();
                                            rawValue = newRawValueBuf.toString();
                                            break block12;
                                        }
                                        if (hadBackslash) {
                                            hadBackslash = false;
                                            c = header.charAt(i++);
                                            newRawValueBuf.append(c);
                                            switch (c) {
                                                case '\"': 
                                                case '\'': 
                                                case '\\': {
                                                    newValueBuf.setCharAt(newValueBuf.length() - 1, c);
                                                    continue block13;
                                                }
                                            }
                                            newValueBuf.append(c);
                                            continue;
                                        }
                                        c = header.charAt(i++);
                                        newRawValueBuf.append(c);
                                        if (c == q) {
                                            value2 = newValueBuf.toString();
                                            rawValue = newRawValueBuf.toString();
                                            break block12;
                                        }
                                        newValueBuf.append(c);
                                        if (c != '\\') continue;
                                        hadBackslash = true;
                                    }
                                }
                                int semiPos = header.indexOf(59, i);
                                if (semiPos > 0) {
                                    value2 = rawValue = header.substring(newValueStart, semiPos);
                                    i = semiPos;
                                    break block12;
                                }
                                value2 = rawValue = header.substring(newValueStart);
                                i = headerLen;
                                break block12;
                            }
                            default: {
                                if (++i != headerLen) continue block12;
                                name = header.substring(newNameStart);
                                rawValue = null;
                                value2 = null;
                                break block12;
                            }
                        }
                        break;
                    }
                }
                names.add(name);
                values2.add(value2);
                rawValues.add(rawValue);
                continue block10;
            }
            break block10;
        }
    }
}

