/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.multipart;

import java.io.UnsupportedEncodingException;

public class MultipartEncodingUtil {
    public static byte[] getAsciiBytes(String data2) {
        try {
            return data2.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getAsciiString(byte[] data2) {
        if (data2 == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return new String(data2, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getBytes(String data2, String charset) {
        if (data2 == null) {
            throw new IllegalArgumentException("data may not be null");
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return data2.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.format("Unsupported encoding: %s", charset));
        }
    }
}

