/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.providers.grizzly.TransportCustomizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyAsyncHttpProviderConfig
implements AsyncHttpProviderConfig<Property, Object> {
    private final Map<Property, Object> attributes = new HashMap<Property, Object>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AsyncHttpProviderConfig addProperty(Property name, Object value2) {
        if (name == null) {
            return this;
        }
        if (value2 == null) {
            if (!name.hasDefaultValue()) return this;
            value2 = name.defaultValue;
        } else if (!name.type.isAssignableFrom(value2.getClass())) {
            throw new IllegalArgumentException(String.format("The value of property [%s] must be of type [%s].  Type of value provided: [%s].", name.name(), name.type.getName(), value2.getClass().getName()));
        }
        this.attributes.put(name, value2);
        return this;
    }

    @Override
    public Object getProperty(Property name) {
        Object ret = this.attributes.get((Object)name);
        if (ret == null && name.hasDefaultValue()) {
            ret = name.defaultValue;
        }
        return ret;
    }

    @Override
    public Object removeProperty(Property name) {
        if (name == null) {
            return null;
        }
        return this.attributes.remove((Object)name);
    }

    @Override
    public Set<Map.Entry<Property, Object>> propertiesSet() {
        return this.attributes.entrySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        TRANSPORT_CUSTOMIZER(TransportCustomizer.class),
        MAX_HTTP_PACKET_HEADER_SIZE(Integer.class, 8192),
        BUFFER_WEBSOCKET_FRAGMENTS(Boolean.class, true);

        final Object defaultValue;
        final Class<?> type;

        private Property(Class<?> type, Object defaultValue) {
            this.type = type;
            this.defaultValue = defaultValue;
        }

        private Property(Class<?> type) {
            this(type, null);
        }

        boolean hasDefaultValue() {
            return this.defaultValue != null;
        }
    }
}

