/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cookie
implements Comparable<Cookie> {
    private final String domain;
    private final String name;
    private final String value;
    private final String rawValue;
    private final String path;
    private final int maxAge;
    private final boolean secure;
    private final int version;
    private final boolean httpOnly;
    private final boolean discard;
    private final String comment;
    private final String commentUrl;
    private Set<Integer> ports = Collections.emptySet();
    private Set<Integer> unmodifiablePorts = this.ports;

    public Cookie(String domain, String name, String value2, String path, int maxAge, boolean secure) {
        this(domain, name, value2, path, maxAge, secure, 1);
    }

    public Cookie(String domain, String name, String value2, String path, int maxAge, boolean secure, int version) {
        this(domain, name, value2, value2, path, maxAge, secure, version, false, false, null, null, Collections.emptySet());
    }

    public Cookie(String domain, String name, String value2, String rawValue, String path, int maxAge, boolean secure, int version, boolean httpOnly, boolean discard, String comment2, String commentUrl, Iterable<Integer> ports) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if ((name = name.trim()).length() == 0) {
            throw new IllegalArgumentException("empty name");
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c > '\u007f') {
                throw new IllegalArgumentException("name contains non-ascii character: " + name);
            }
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ';': 
                case '=': {
                    throw new IllegalArgumentException("name contains one of the following prohibited characters: =,; \\t\\r\\n\\v\\f: " + name);
                }
            }
        }
        if (name.charAt(0) == '$') {
            throw new IllegalArgumentException("name starting with '$' not allowed: " + name);
        }
        if (value2 == null) {
            throw new NullPointerException("value");
        }
        this.name = name;
        this.value = value2;
        this.rawValue = rawValue;
        this.domain = this.validateValue("domain", domain);
        this.path = this.validateValue("path", path);
        this.maxAge = maxAge;
        this.secure = secure;
        this.version = version;
        this.httpOnly = httpOnly;
        this.comment = version > 0 ? this.validateValue("comment", comment2) : null;
        if (version > 1) {
            this.discard = discard;
            this.commentUrl = this.validateValue("commentUrl", commentUrl);
            this.setPorts(ports);
        } else {
            this.discard = false;
            this.commentUrl = null;
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public String getValue() {
        return this.value == null ? "" : this.value;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public String getPath() {
        return this.path;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public int getVersion() {
        return this.version;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCommentUrl() {
        return this.commentUrl;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public Set<Integer> getPorts() {
        if (this.unmodifiablePorts == null) {
            this.unmodifiablePorts = Collections.unmodifiableSet(this.ports);
        }
        return this.unmodifiablePorts;
    }

    @Deprecated
    public void setPorts(int ... ports) {
        if (ports == null) {
            throw new NullPointerException("ports");
        }
        int[] portsCopy = (int[])ports.clone();
        if (portsCopy.length == 0) {
            this.ports = Collections.emptySet();
            this.unmodifiablePorts = this.ports;
        } else {
            TreeSet<Integer> newPorts = new TreeSet<Integer>();
            for (int p : portsCopy) {
                if (p <= 0 || p > 65535) {
                    throw new IllegalArgumentException("port out of range: " + p);
                }
                newPorts.add(p);
            }
            this.ports = newPorts;
            this.unmodifiablePorts = null;
        }
    }

    @Deprecated
    public void setPorts(Iterable<Integer> ports) {
        TreeSet<Integer> newPorts = new TreeSet<Integer>();
        for (int p : ports) {
            if (p <= 0 || p > 65535) {
                throw new IllegalArgumentException("port out of range: " + p);
            }
            newPorts.add(p);
        }
        if (newPorts.isEmpty()) {
            this.ports = Collections.emptySet();
            this.unmodifiablePorts = this.ports;
        } else {
            this.ports = newPorts;
            this.unmodifiablePorts = null;
        }
    }

    public String toString() {
        return String.format("Cookie: domain=%s, name=%s, value=%s, path=%s, maxAge=%d, secure=%s", this.domain, this.name, this.value, this.path, this.maxAge, this.secure);
    }

    private String validateValue(String name, String value2) {
        if (value2 == null) {
            return null;
        }
        if ((value2 = value2.trim()).length() == 0) {
            return null;
        }
        for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            switch (c) {
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ';': {
                    throw new IllegalArgumentException(name + " contains one of the following prohibited characters: " + ";\\r\\n\\f\\v (" + value2 + ')');
                }
            }
        }
        return value2;
    }

    @Override
    public int compareTo(Cookie c) {
        int v = this.getName().compareToIgnoreCase(c.getName());
        if (v != 0) {
            return v;
        }
        if (this.getPath() == null) {
            if (c.getPath() != null) {
                return -1;
            }
        } else {
            if (c.getPath() == null) {
                return 1;
            }
            v = this.getPath().compareTo(c.getPath());
            if (v != 0) {
                return v;
            }
        }
        if (this.getDomain() == null) {
            if (c.getDomain() != null) {
                return -1;
            }
        } else {
            if (c.getDomain() == null) {
                return 1;
            }
            v = this.getDomain().compareToIgnoreCase(c.getDomain());
            return v;
        }
        return 0;
    }
}

