/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.util.Util;
import sun.misc.Unsafe;

public class Sequence {
    static final long INITIAL_VALUE = -1L;
    private static final Unsafe UNSAFE = Util.getUnsafe();
    private static final long VALUE_OFFSET;
    private final long[] paddedValue = new long[15];

    public Sequence() {
        this(-1L);
    }

    public Sequence(long initialValue) {
        UNSAFE.putOrderedLong(this.paddedValue, VALUE_OFFSET, initialValue);
    }

    public long get() {
        return UNSAFE.getLongVolatile(this.paddedValue, VALUE_OFFSET);
    }

    public void set(long value2) {
        UNSAFE.putOrderedLong(this.paddedValue, VALUE_OFFSET, value2);
    }

    public void setVolatile(long value2) {
        UNSAFE.putLongVolatile(this.paddedValue, VALUE_OFFSET, value2);
    }

    public boolean compareAndSet(long expectedValue, long newValue) {
        return UNSAFE.compareAndSwapLong(this.paddedValue, VALUE_OFFSET, expectedValue, newValue);
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public long addAndGet(long increment) {
        long newValue;
        long currentValue;
        while (!this.compareAndSet(currentValue = this.get(), newValue = currentValue + increment)) {
        }
        return newValue;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    static {
        int base = UNSAFE.arrayBaseOffset(long[].class);
        int scale = UNSAFE.arrayIndexScale(long[].class);
        VALUE_OFFSET = base + scale * 7;
    }
}

