/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.impl;

import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.spi.JsonProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class AbstractJsonProvider
implements JsonProvider {
    @Override
    public Object clone(Object obj) {
        return Utils.clone((Serializable)obj);
    }

    @Override
    public boolean isContainer(Object obj) {
        return this.isArray(obj) || this.isMap(obj);
    }

    @Override
    public boolean isArray(Object obj) {
        return obj instanceof List;
    }

    @Override
    public Object getProperty(Object obj, Object key) {
        if (this.isMap(obj)) {
            return ((Map)obj).get(key.toString());
        }
        int index = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
        return ((List)obj).get(index);
    }

    @Override
    public void setProperty(Object obj, Object key, Object value2) {
        if (this.isMap(obj)) {
            ((Map)obj).put(key.toString(), value2);
        } else {
            int index = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
            ((List)obj).add(index, value2);
        }
    }

    @Override
    public boolean isMap(Object obj) {
        return obj instanceof Map;
    }

    @Override
    public Collection<String> getPropertyKeys(Object obj) {
        if (this.isArray(obj)) {
            List l = (List)obj;
            ArrayList<String> keys = new ArrayList<String>(l.size());
            for (int i = 0; i < l.size(); ++i) {
                keys.add(String.valueOf(i));
            }
            return keys;
        }
        return ((Map)obj).keySet();
    }

    @Override
    public int length(Object obj) {
        if (this.isArray(obj)) {
            return ((List)obj).size();
        }
        return this.getPropertyKeys(obj).size();
    }

    @Override
    public Iterable<Object> toIterable(Object obj) {
        if (this.isArray(obj)) {
            return (Iterable)obj;
        }
        return ((Map)obj).values();
    }
}

