/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal;

public class JsonFormatter {
    private static final String INDENT = "   ";
    private static final String NEW_LINE = System.getProperty("line.separator");

    private static void appendIndent(StringBuilder sb, int count2) {
        while (count2 > 0) {
            sb.append(INDENT);
            --count2;
        }
    }

    private static boolean isEscaped(StringBuilder sb, int index) {
        boolean escaped = false;
        while (index > 0 && sb.charAt(--index) == '\\') {
            escaped = !escaped;
        }
        return escaped;
    }

    public static String prettyPrint(String input2) {
        StringBuilder output2 = new StringBuilder(input2.length() * 2);
        boolean quoteOpened = false;
        int depth = 0;
        block7: for (int i = 0; i < input2.length(); ++i) {
            char ch = input2.charAt(i);
            switch (ch) {
                case '[': 
                case '{': {
                    output2.append(ch);
                    if (quoteOpened) continue block7;
                    output2.append(NEW_LINE);
                    JsonFormatter.appendIndent(output2, ++depth);
                    continue block7;
                }
                case ']': 
                case '}': {
                    if (quoteOpened) {
                        output2.append(ch);
                        continue block7;
                    }
                    output2.append(NEW_LINE);
                    JsonFormatter.appendIndent(output2, --depth);
                    output2.append(ch);
                    continue block7;
                }
                case '\"': 
                case '\'': {
                    output2.append(ch);
                    if (quoteOpened) {
                        if (JsonFormatter.isEscaped(output2, i)) continue block7;
                        quoteOpened = false;
                        continue block7;
                    }
                    quoteOpened = true;
                    continue block7;
                }
                case ',': {
                    output2.append(ch);
                    if (quoteOpened) continue block7;
                    output2.append(NEW_LINE);
                    JsonFormatter.appendIndent(output2, depth);
                    continue block7;
                }
                case ':': {
                    if (quoteOpened) {
                        output2.append(ch);
                        continue block7;
                    }
                    output2.append(" : ");
                    continue block7;
                }
                default: {
                    if (!quoteOpened && ch == ' ') continue block7;
                    output2.append(ch);
                }
            }
        }
        return output2.toString();
    }
}

