/*
 * Decompiled with CFR 0.152.
 */
package com.iterative.groovy.service;

import com.iterative.groovy.service.GroovyShellAcceptor;
import com.iterative.groovy.service.GroovyShellServiceMBean;
import groovy.lang.Binding;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyShellService
implements GroovyShellServiceMBean {
    private static final Logger log = LoggerFactory.getLogger(GroovyShellService.class);
    private int port;
    private Map<String, Object> bindings;
    private GroovyShellAcceptor groovyShellAcceptor;
    private Thread acceptorThread;
    private List<String> defaultScripts = new ArrayList<String>();
    private boolean launchAtStart = true;

    public GroovyShellService() {
        this(6789);
    }

    public GroovyShellService(int port) {
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Wrong port number");
        }
        this.port = port;
    }

    public Map<String, Object> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, Object> bindings) {
        this.bindings = bindings;
    }

    public int getPort() {
        return this.port;
    }

    public void addDefaultScript(String script) {
        this.defaultScripts.add(script);
    }

    public void setDefaultScriptNames(String scriptNames) {
        this.defaultScripts = Arrays.asList(scriptNames.split(","));
    }

    public List<String> getDefaultScripts() {
        return this.defaultScripts;
    }

    public void setPort(int port) {
        this.port = port;
    }

    private ObjectName getJMXObjectName() throws MalformedObjectNameException {
        return new ObjectName(this.getClass().getName() + ":port=" + this.port);
    }

    public void setLaunchAtStart(boolean launchAtStart) {
        this.launchAtStart = launchAtStart;
    }

    public synchronized void start() throws IOException {
        if (this.launchAtStart && this.acceptorThread == null) {
            try {
                ManagementFactory.getPlatformMBeanServer().registerMBean(this, this.getJMXObjectName());
            }
            catch (JMException e) {
                log.warn("Failed to register GroovyShellService MBean", e);
            }
            this.groovyShellAcceptor = new GroovyShellAcceptor(this.port, GroovyShellService.createBinding(this.bindings), this.defaultScripts);
            this.acceptorThread = new Thread((Runnable)this.groovyShellAcceptor, "GroovyShAcceptor-" + this.port);
            this.acceptorThread.start();
        }
    }

    public synchronized void destroy() throws InterruptedException {
        if (this.acceptorThread != null) {
            this.acceptorThread.interrupt();
            this.acceptorThread.join();
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.getJMXObjectName());
            }
            catch (JMException e) {
                log.warn("Failed to unregister GroovyShellService MBean", e);
            }
            this.acceptorThread = null;
        }
    }

    @Override
    public void killAllClients() {
        this.groovyShellAcceptor.killAllClients();
    }

    private static Binding createBinding(Map<String, Object> objects) {
        Binding binding = new Binding();
        if (objects != null) {
            for (Map.Entry<String, Object> row : objects.entrySet()) {
                binding.setVariable(row.getKey(), row.getValue());
            }
        }
        return binding;
    }
}

