/*
 * Decompiled with CFR 0.152.
 */
package com.iterative.groovy.service;

import com.iterative.groovy.service.ClientTask;
import com.iterative.groovy.service.ClientTaskThread;
import groovy.lang.Binding;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyShellAcceptor
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(GroovyShellAcceptor.class);
    private final ServerSocket serverSocket;
    private final Binding binding;
    private List<ClientTaskThread> clientThreads = new LinkedList<ClientTaskThread>();
    private List<String> defaultScripts;
    private static int clientSequence = 0;

    public GroovyShellAcceptor(int port, Binding binding, List<String> defaultScripts) throws IOException {
        if (port <= 0) {
            throw new IllegalArgumentException("Port number should be positive integer");
        }
        this.serverSocket = new ServerSocket(port);
        this.serverSocket.setSoTimeout(1000);
        this.binding = binding;
        this.defaultScripts = defaultScripts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            log.info("Groovy shell started on {}", (Object)this.serverSocket);
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Socket clientSocket = this.serverSocket.accept();
                    log.debug("Groovy shell client accepted: {}", (Object)clientSocket);
                    GroovyShellAcceptor groovyShellAcceptor = this;
                    synchronized (groovyShellAcceptor) {
                        ClientTask clientTask = new ClientTask(clientSocket, this.binding, this.defaultScripts);
                        ClientTaskThread clientThread = new ClientTaskThread(clientTask, "GroovyShClient-" + clientSequence++);
                        this.clientThreads.add(clientThread);
                        clientThread.start();
                        log.debug("Groovy shell thread started: {}", (Object)clientThread.getName());
                    }
                }
                catch (SocketTimeoutException e) {
                    Thread.yield();
                }
                catch (SocketException e) {
                    log.error("Stopping groovy shell thread", e);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Error in shell dispatcher thread. Stopping thread", e);
        }
        finally {
            this.killAllClients();
            GroovyShellAcceptor.closeQuietly(this.serverSocket);
            log.info("Groovy shell stopped");
        }
    }

    public synchronized void killAllClients() {
        for (ClientTaskThread thread : this.clientThreads) {
            thread.kill();
        }
        this.clientThreads.clear();
    }

    private static void closeQuietly(ServerSocket socket) {
        try {
            socket.close();
        }
        catch (IOException e) {
            log.warn("Error while closing socket", e);
        }
    }
}

