/*
 * Decompiled with CFR 0.152.
 */
package com.iterative.groovy.service;

import com.iterative.groovy.service.ClientTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTaskThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ClientTaskThread.class);
    private ClientTask clientTask;

    public ClientTaskThread(ClientTask runnable, String threadName) {
        super((Runnable)runnable, threadName);
        this.clientTask = runnable;
    }

    public void kill() {
        this.interrupt();
        this.clientTask.closeSocket();
        try {
            this.join(500L);
        }
        catch (InterruptedException e) {
            ClientTaskThread.currentThread().interrupt();
        }
        if (this.isAlive()) {
            log.warn(this.getName() + " not responding to interrupts ... forcibly stopping");
            this.stop();
        }
    }
}

