/*
 * Decompiled with CFR 0.152.
 */
package com.iterative.groovy.service;

import groovy.lang.Binding;
import groovy.lang.Closure;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.tools.shell.Command;
import org.codehaus.groovy.tools.shell.ExitNotification;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.codehaus.groovy.tools.shell.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ClientTask.class);
    private final Socket socket;
    private final Binding binding;
    private final List<String> defaultScripts;

    public ClientTask(Socket socket, Binding binding, List<String> defaultScripts) {
        this.socket = socket;
        this.binding = binding;
        this.defaultScripts = defaultScripts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PrintStream out = null;
        InputStream in = null;
        try {
            out = new PrintStream(this.socket.getOutputStream(), true, "utf8");
            in = this.socket.getInputStream();
            this.binding.setVariable("out", out);
            IO io = new IO(in, out, out);
            Groovysh shell = new Groovysh(this.binding, io);
            Exception cause = null;
            try {
                this.loadDefaultScripts(shell);
            }
            catch (Exception e) {
                log.error("Error while loading default script", e);
                cause = e;
            }
            final Closure defaultErrorHook = shell.getErrorHook();
            shell.setErrorHook(new Closure<Groovysh>((Object)this){

                @Override
                public Groovysh call(Object ... args) {
                    if (ClientTask.this.socket.isClosed()) {
                        throw new ExitNotification(0);
                    }
                    return (Groovysh)defaultErrorHook.call(args);
                }
            });
            try {
                if (cause != null) {
                    out.println("Unable to load default script: " + cause);
                }
                shell.run(new String[0]);
            }
            catch (Exception e) {
                log.error("Error while executing client command", e);
            }
        }
        catch (Exception e) {
            try {
                log.error("Exception in groovy shell client thread", e);
            }
            catch (Throwable throwable) {
                ClientTask.closeQuietly(in);
                ClientTask.closeQuietly(out);
                ClientTask.closeQuietly(this.socket);
                throw throwable;
            }
            ClientTask.closeQuietly(in);
            ClientTask.closeQuietly(out);
            ClientTask.closeQuietly(this.socket);
        }
        ClientTask.closeQuietly(in);
        ClientTask.closeQuietly(out);
        ClientTask.closeQuietly(this.socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultScripts(final Groovysh shell) {
        if (!this.defaultScripts.isEmpty()) {
            Closure defaultResultHook = shell.getResultHook();
            try {
                shell.setResultHook(new Closure<Groovysh>((Object)this){

                    @Override
                    public Groovysh call(Object ... args) {
                        return shell;
                    }
                });
                Command cmd = shell.getRegistry().find("load");
                for (String script : this.defaultScripts) {
                    cmd.execute(Arrays.asList(script));
                }
            }
            finally {
                shell.setResultHook(defaultResultHook);
            }
        }
    }

    public void closeSocket() {
        ClientTask.closeQuietly(this.socket);
    }

    private static void closeQuietly(Closeable object) {
        try {
            object.close();
        }
        catch (IOException e) {
            log.warn("Error while closing object", e);
        }
    }

    private static void closeQuietly(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException e) {
            log.warn("Error while closing socket", e);
        }
    }
}

