/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.repositories;

import com.github.joschi.jadconfig.Repository;
import com.github.joschi.jadconfig.RepositoryException;
import java.util.HashMap;
import java.util.Map;

public class InMemoryRepository
implements Repository {
    private Map<String, String> properties = null;

    public InMemoryRepository() {
    }

    public InMemoryRepository(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public void open() throws RepositoryException {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
    }

    @Override
    public String read(String name) {
        if (this.properties == null) {
            throw new IllegalStateException("Repository has already been closed or has never been opened");
        }
        return this.properties.get(name);
    }

    @Override
    public void write(String name, String value2) throws RepositoryException {
        if (this.properties == null) {
            throw new IllegalStateException("Repository has already been closed or has never been opened");
        }
        this.properties.put(name, value2);
    }

    @Override
    public void save() throws RepositoryException {
    }

    @Override
    public void close() throws RepositoryException {
        if (this.properties == null) {
            throw new IllegalStateException("Repository has already been closed or has never been opened");
        }
        this.properties = null;
    }

    public int size() {
        if (this.properties == null) {
            throw new IllegalStateException("Call open before attempting any other operation");
        }
        return this.properties.size();
    }
}

