/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class InetSocketAddressConverter
implements Converter<InetSocketAddress> {
    private static final String SEPARATOR = ":";

    @Override
    public InetSocketAddress convertFrom(String value2) {
        InetSocketAddress result2;
        try {
            if (null == value2) {
                throw new NullPointerException("value must not be null!");
            }
            int lastIndexSeparator = value2.lastIndexOf(SEPARATOR);
            String hostname = value2.substring(0, lastIndexSeparator);
            String port = value2.substring(lastIndexSeparator + 1, value2.length());
            if (null == hostname || hostname.isEmpty()) {
                throw new UnknownHostException("hostname must not be empty!");
            }
            InetAddress hostAddress = InetAddress.getByName(hostname);
            result2 = new InetSocketAddress(hostAddress, Integer.parseInt(port));
        }
        catch (Exception ex) {
            throw new ParameterException("Couldn't convert value \"" + value2 + "\" to InetSocketAddress.", ex);
        }
        return result2;
    }

    @Override
    public String convertTo(InetSocketAddress value2) {
        if (value2 == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        if (value2.getAddress() instanceof Inet6Address) {
            return String.format("[%s]%s%d", value2.getAddress().getHostAddress(), SEPARATOR, value2.getPort());
        }
        return String.format("%s%s%d", value2.getHostName(), SEPARATOR, value2.getPort());
    }
}

