/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import java.net.InetAddress;

public class InetAddressConverter
implements Converter<InetAddress> {
    @Override
    public InetAddress convertFrom(String value2) {
        InetAddress result2;
        try {
            if (null == value2) {
                throw new NullPointerException("value must not be null!");
            }
            result2 = InetAddress.getByName(value2);
        }
        catch (Exception ex) {
            throw new ParameterException("Couldn't convert value \"" + value2 + "\" to InetAddress.", ex);
        }
        return result2;
    }

    @Override
    public String convertTo(InetAddress value2) {
        if (value2 == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        return value2.getCanonicalHostName();
    }
}

