/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Inet6AddressConverter
implements Converter<Inet6Address> {
    @Override
    public Inet6Address convertFrom(String value2) {
        Inet6Address result2;
        try {
            if (null == value2) {
                throw new NullPointerException("value must not be null!");
            }
            InetAddress inetAddress = InetAddress.getByName(value2);
            if (!(inetAddress instanceof Inet6Address)) {
                throw new UnknownHostException(value2);
            }
            result2 = (Inet6Address)inetAddress;
        }
        catch (Exception ex) {
            throw new ParameterException("Couldn't convert value \"" + value2 + "\" to Inet6Address.", ex);
        }
        return result2;
    }

    @Override
    public String convertTo(Inet6Address value2) {
        if (value2 == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        return value2.getHostAddress();
    }
}

