/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Inet4AddressConverter
implements Converter<Inet4Address> {
    @Override
    public Inet4Address convertFrom(String value2) {
        Inet4Address result2;
        try {
            if (null == value2) {
                throw new NullPointerException("value must not be null!");
            }
            InetAddress inetAddress = InetAddress.getByName(value2);
            if (!(inetAddress instanceof Inet4Address)) {
                throw new UnknownHostException(value2);
            }
            result2 = (Inet4Address)inetAddress;
        }
        catch (Exception ex) {
            throw new ParameterException("Couldn't convert value \"" + value2 + "\" to Inet4Address.", ex);
        }
        return result2;
    }

    @Override
    public String convertTo(Inet4Address value2) {
        if (value2 == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        return value2.getHostAddress();
    }
}

