/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ConverterFactory;
import com.github.joschi.jadconfig.DefaultConverterFactory;
import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ParameterException;
import com.github.joschi.jadconfig.ReflectionUtils;
import com.github.joschi.jadconfig.Repository;
import com.github.joschi.jadconfig.RepositoryException;
import com.github.joschi.jadconfig.Strings;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.Validator;
import com.github.joschi.jadconfig.ValidatorMethod;
import com.github.joschi.jadconfig.converters.NoConverter;
import com.github.joschi.jadconfig.converters.StringConverter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadConfig {
    private static final Logger LOG = LoggerFactory.getLogger(JadConfig.class);
    private final LinkedList<ConverterFactory> converterFactories = new LinkedList();
    private List<Object> configurationBeans;
    private List<Repository> repositories;

    public JadConfig() {
        this(Collections.emptyList(), new ArrayList());
    }

    public JadConfig(Repository repository, Object ... configurationBeans) {
        this(Collections.singletonList(repository), configurationBeans);
    }

    public JadConfig(Collection<Repository> repositories, Object ... configurationBeans) {
        this.configurationBeans = new ArrayList<Object>(Arrays.asList(configurationBeans));
        this.repositories = new ArrayList<Repository>(repositories);
        this.converterFactories.add(new DefaultConverterFactory());
    }

    public void process() throws RepositoryException, ValidationException {
        for (Repository repository : this.repositories) {
            LOG.debug("Opening repository {}", (Object)repository);
            repository.open();
        }
        for (Object configurationBean : this.configurationBeans) {
            LOG.debug("Processing configuration bean {}", configurationBean);
            this.processClassFields(configurationBean, ReflectionUtils.getAllFields(configurationBean.getClass()));
            this.invokeValidatorMethods(configurationBean, ReflectionUtils.getAllMethods(configurationBean.getClass()));
        }
    }

    private void processClassFields(Object configurationBean, Field[] fields) throws ValidationException {
        for (Field field2 : fields) {
            Parameter parameter = field2.getAnnotation(Parameter.class);
            if (parameter == null) continue;
            LOG.debug("Processing field {}", (Object)parameter);
            Object fieldValue = this.getFieldValue(field2, configurationBean);
            String parameterName = parameter.value();
            String parameterValue = null;
            for (Repository repository : this.repositories) {
                LOG.debug("Looking up parameter {} in repository {}", (Object)parameterName, (Object)repository);
                parameterValue = repository.read(parameterName);
                if (null == parameterValue) continue;
                break;
            }
            if (parameterValue == null && fieldValue == null && parameter.required()) {
                throw new ParameterException("Required parameter \"" + parameterName + "\" not found.");
            }
            if (parameterValue != null) {
                if (parameter.trim()) {
                    LOG.debug("Trimmed parameter value {}", (Object)parameterName);
                    parameterValue = Strings.trim(parameterValue);
                }
                LOG.debug("Validating parameter {}", (Object)parameterName);
                this.validateParameter(parameter.validator(), parameterName, parameterValue);
                LOG.debug("Converting parameter value {}", (Object)parameterName);
                fieldValue = this.convertStringValue(field2.getType(), parameter.converter(), parameterValue);
            }
            LOG.debug("Setting parameter {} to {}", (Object)parameterName, (Object)parameterValue);
            try {
                field2.set(configurationBean, fieldValue);
            }
            catch (Exception e) {
                throw new ParameterException("Couldn't set field " + field2.getName(), e);
            }
        }
    }

    private Object convertStringValue(Class<?> fieldType, Class<? extends Converter<?>> converterClass, String stringValue) {
        Converter converter = this.getConverter(fieldType, converterClass);
        LOG.debug("Loaded converter class for type {}: {}", (Object)fieldType, (Object)converter);
        return converter.convertFrom(stringValue);
    }

    private Object getFieldValue(Field field2, Object bean) {
        try {
            return ReflectionUtils.getFieldValue(bean, field2);
        }
        catch (IllegalAccessException e) {
            throw new ParameterException("Couldn't obtain value of field " + field2.getName(), e);
        }
    }

    private Converter getConverter(Class<?> fieldType, Class<? extends Converter<?>> converterClass) {
        LOG.debug("Trying to find converter class {} for type {}", (Object)converterClass, (Object)fieldType);
        Class<Converter<Object>> clazz = converterClass;
        if (clazz == null || clazz == NoConverter.class) {
            clazz = this.findConverter(fieldType);
        }
        if (clazz == null) {
            clazz = StringConverter.class;
            LOG.debug("Using fallback converter: {}", (Object)clazz);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ParameterException("Couldn't initialize converter class " + clazz.getCanonicalName(), e);
        }
    }

    private void validateParameter(Class<? extends Validator> validatorClass, String name, String value2) throws ValidationException {
        Validator validator;
        LOG.debug("Validating parameter {} with value {}", (Object)name, (Object)value2);
        try {
            validator = validatorClass.newInstance();
        }
        catch (Exception e) {
            throw new ParameterException("Couldn't initialize validator " + validatorClass.getCanonicalName(), e);
        }
        validator.validate(name, value2);
    }

    private void invokeValidatorMethods(Object configurationBean, Method[] methods) throws ValidationException {
        try {
            ReflectionUtils.invokeMethodsWithAnnotation(configurationBean, ValidatorMethod.class, methods);
        }
        catch (Exception e) {
            throw new ValidationException("Couldn't run validator method", e);
        }
    }

    private <T> Class<? extends Converter<T>> findConverter(Class<T> clazz) {
        for (ConverterFactory factory : this.converterFactories) {
            Class<Converter<T>> result2 = factory.getConverter(clazz);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public void addConverterFactory(ConverterFactory converterFactory) {
        this.converterFactories.addFirst(converterFactory);
        LOG.info("Added converter factory {}", (Object)converterFactory);
    }

    public void addConfigurationBean(Object configurationBean) {
        this.configurationBeans.add(configurationBean);
        LOG.info("Added configuration bean {}", configurationBean);
    }

    public void save() throws RepositoryException {
        LOG.info("Saving changed configuration parameters");
        for (Object configurationBean : this.configurationBeans) {
            LOG.debug("Checking declared fields of {}", configurationBean);
            for (Field field2 : ReflectionUtils.getAllFields(configurationBean.getClass())) {
                Parameter parameter = field2.getAnnotation(Parameter.class);
                LOG.debug("Checking declared field {} of {}", (Object)parameter, configurationBean);
                if (parameter == null) continue;
                Object fieldValue = this.getFieldValue(field2, configurationBean);
                LOG.debug("Retrieved field value {} = {}", (Object)field2, fieldValue);
                if (fieldValue == null) continue;
                String stringValue = this.convertFieldValue(field2.getType(), parameter.converter(), fieldValue);
                for (Repository repository : this.repositories) {
                    LOG.debug("Writing {} = {} to repository {}", parameter.value(), stringValue, repository);
                    repository.write(parameter.value(), stringValue);
                }
            }
        }
        for (Repository repository : this.repositories) {
            LOG.debug("Saving changes to repository {}", (Object)repository);
            repository.save();
        }
    }

    public Map<String, String> dump() {
        HashMap<String, String> configurationDump = new HashMap<String, String>();
        for (Object configurationBean : this.configurationBeans) {
            for (Field field2 : ReflectionUtils.getAllFields(configurationBean.getClass())) {
                Parameter parameter = field2.getAnnotation(Parameter.class);
                if (parameter == null) continue;
                Object fieldValue = this.getFieldValue(field2, configurationBean);
                configurationDump.put(parameter.value(), this.convertFieldValue(field2.getType(), parameter.converter(), fieldValue));
            }
        }
        return configurationDump;
    }

    private String convertFieldValue(Class<?> fieldType, Class<? extends Converter<?>> converterClass, Object fieldValue) {
        if (null != fieldValue) {
            Converter converter = this.getConverter(fieldType, converterClass);
            LOG.debug("Converting {} to type {} using converter {}", fieldValue, fieldType, converter);
            return converter.convertTo(fieldValue);
        }
        return "null";
    }

    public void setRepository(Repository repository) {
        this.repositories = Collections.singletonList(repository);
    }

    public void setRepositories(Collection<Repository> repositories) {
        this.repositories = new ArrayList<Repository>(repositories);
    }
}

