/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.ser.JacksonJodaFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import java.io.IOException;
import java.lang.reflect.Type;
import org.joda.time.LocalTime;

public final class LocalTimeSerializer
extends JodaDateSerializerBase<LocalTime> {
    protected static final JacksonJodaFormat DEFAULT_FORMAT = new JacksonJodaFormat(DEFAULT_TIMEONLY_FORMAT);

    public LocalTimeSerializer() {
        this(DEFAULT_FORMAT);
    }

    public LocalTimeSerializer(JacksonJodaFormat format2) {
        super(LocalTime.class, format2);
    }

    public LocalTimeSerializer withFormat(JacksonJodaFormat formatter) {
        return this._format == formatter ? this : new LocalTimeSerializer(formatter);
    }

    @Override
    public void serialize(LocalTime value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._useTimestamp(provider)) {
            jgen.writeStartArray();
            jgen.writeNumber(value2.hourOfDay().get());
            jgen.writeNumber(value2.minuteOfHour().get());
            jgen.writeNumber(value2.secondOfMinute().get());
            jgen.writeNumber(value2.millisOfSecond().get());
            jgen.writeEndArray();
        } else {
            jgen.writeString(this._format.createFormatter(provider).print(value2));
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(this._useTimestamp(provider) ? "array" : "string", true);
    }
}

